/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth.process;

import java.util.ArrayList;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.devkit.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.common.connection.exception.UnableToAcquireConnectionException;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.callback.ProcessCallback;
import org.mule.security.oauth.process.ManagedAccessTokenProcessInterceptor;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class ManagedAccessTokenProcessInterceptorTestCase {
    private static final String ACCESS_TOKEN_ID = "accessTokenId";
    @Mock
    private ProcessInterceptor<Object, OAuth2Adapter> next;
    private OAuth2Manager<OAuth2Adapter> manager;
    @Mock
    private ProcessCallback<Object, OAuth2Adapter> callback;
    @Mock(extraInterfaces={MessageProcessor.class})
    private DevkitBasedMessageProcessor processor;
    @Mock
    private OAuth2Adapter adapter;
    private MuleEvent event;
    private ManagedAccessTokenProcessInterceptor<Object> interceptor;

    @Before
    public void setUp() throws Exception {
        this.manager = (OAuth2Manager)Mockito.mock(OAuth2Manager.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        this.interceptor = new ManagedAccessTokenProcessInterceptor(this.next, this.manager);
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.event.getMuleContext().getExpressionManager().parse(Mockito.anyString(), (MuleMessage)Mockito.any(MuleMessage.class))).thenAnswer((Answer)new Answer<String>(){

            public String answer(InvocationOnMock invocation) throws Throwable {
                return (String)invocation.getArguments()[0];
            }
        });
        ArrayList managedExceptions = new ArrayList();
        Mockito.when((Object)this.callback.getManagedExceptions()).thenReturn(managedExceptions);
    }

    @Test
    public void unprotected() throws Exception {
        OAuth2Adapter adapter = (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class);
        Mockito.when((Object)this.manager.getDefaultUnauthorizedConnector()).thenReturn((Object)adapter);
        Mockito.when((Object)this.callback.isProtected()).thenReturn((Object)false);
        this.interceptor.execute(this.callback, this.adapter, (MessageProcessor)this.processor, this.event);
        ((ProcessCallback)Mockito.verify(this.callback)).process(Mockito.same((Object)adapter));
        ((OAuth2Manager)Mockito.verify(this.manager, (VerificationMode)Mockito.never())).acquireAccessToken(ACCESS_TOKEN_ID);
    }

    @Test
    public void withConfigName() throws Exception {
        Mockito.when((Object)this.callback.isProtected()).thenReturn((Object)true);
        Mockito.when((Object)this.manager.getDefaultUnauthorizedConnector().getName()).thenReturn((Object)ACCESS_TOKEN_ID);
        Mockito.when((Object)this.manager.acquireAccessToken(ACCESS_TOKEN_ID)).thenReturn((Object)this.adapter);
        this.interceptor.execute(this.callback, this.adapter, (MessageProcessor)this.processor, this.event);
        ((OAuth2Manager)Mockito.verify(this.manager)).acquireAccessToken(ACCESS_TOKEN_ID);
        ((ProcessInterceptor)Mockito.verify(this.next)).execute(this.callback, (Object)this.adapter, (MessageProcessor)this.processor, this.event);
    }

    @Test
    public void withDefaultAccessTokenId() throws Exception {
        Mockito.when((Object)this.callback.isProtected()).thenReturn((Object)true);
        Mockito.when((Object)this.manager.getDefaultAccessTokenId()).thenReturn((Object)ACCESS_TOKEN_ID);
        Mockito.when((Object)this.manager.acquireAccessToken(ACCESS_TOKEN_ID)).thenReturn((Object)this.adapter);
        this.interceptor.execute(this.callback, this.adapter, (MessageProcessor)this.processor, this.event);
        ((OAuth2Manager)Mockito.verify(this.manager)).acquireAccessToken(ACCESS_TOKEN_ID);
        ((ProcessInterceptor)Mockito.verify(this.next)).execute(this.callback, (Object)this.adapter, (MessageProcessor)this.processor, this.event);
    }

    @Test
    public void withCustomAccessTokenId() throws Exception {
        Mockito.when((Object)this.callback.isProtected()).thenReturn((Object)true);
        Mockito.when((Object)this.processor.getAccessTokenId()).thenReturn((Object)ACCESS_TOKEN_ID);
        Mockito.when((Object)this.manager.acquireAccessToken(ACCESS_TOKEN_ID)).thenReturn((Object)this.adapter);
        this.interceptor.execute(this.callback, this.adapter, (MessageProcessor)this.processor, this.event);
        ((OAuth2Manager)Mockito.verify(this.manager)).acquireAccessToken(ACCESS_TOKEN_ID);
        ((ProcessInterceptor)Mockito.verify(this.next)).execute(this.callback, (Object)this.adapter, (MessageProcessor)this.processor, this.event);
    }

    @Test(expected=RuntimeException.class)
    public void managedExceptionWithNotNullAdapter() throws Exception {
        Mockito.when((Object)this.callback.isProtected()).thenReturn((Object)true);
        Mockito.when((Object)this.processor.getAccessTokenId()).thenReturn((Object)ACCESS_TOKEN_ID);
        Mockito.when((Object)this.manager.acquireAccessToken(ACCESS_TOKEN_ID)).thenReturn((Object)this.adapter);
        Mockito.when((Object)this.next.execute(this.callback, (Object)this.adapter, (MessageProcessor)this.processor, this.event)).thenThrow(new Throwable[]{new RuntimeException()});
        this.interceptor.execute(this.callback, this.adapter, (MessageProcessor)this.processor, this.event);
        ((OAuth2Manager)Mockito.verify(this.manager)).acquireAccessToken(ACCESS_TOKEN_ID);
        ((ProcessInterceptor)Mockito.verify(this.next, (VerificationMode)Mockito.never())).execute(this.callback, (Object)this.adapter, (MessageProcessor)this.processor, this.event);
        ((OAuth2Manager)Mockito.verify(this.manager)).destroyAccessToken(ACCESS_TOKEN_ID, this.adapter);
        ((OAuth2Manager)Mockito.verify(this.manager)).releaseAccessToken(ACCESS_TOKEN_ID, this.adapter);
    }

    @Test(expected=RuntimeException.class)
    public void managedExceptionWithNullAdapter() throws Exception {
        Mockito.when((Object)this.callback.isProtected()).thenReturn((Object)true);
        Mockito.when((Object)this.processor.getAccessTokenId()).thenReturn((Object)ACCESS_TOKEN_ID);
        Mockito.when((Object)this.manager.acquireAccessToken(ACCESS_TOKEN_ID)).thenThrow(new Throwable[]{new RuntimeException()});
        this.interceptor.execute(this.callback, this.adapter, (MessageProcessor)this.processor, this.event);
        ((OAuth2Manager)Mockito.verify(this.manager)).acquireAccessToken(ACCESS_TOKEN_ID);
        ((ProcessInterceptor)Mockito.verify(this.next, (VerificationMode)Mockito.never())).execute(this.callback, (Object)this.adapter, (MessageProcessor)this.processor, this.event);
        ((OAuth2Manager)Mockito.verify(this.manager, (VerificationMode)Mockito.never())).destroyAccessToken(ACCESS_TOKEN_ID, (OAuth2Adapter)Mockito.any(OAuth2Adapter.class));
        ((OAuth2Manager)Mockito.verify(this.manager, (VerificationMode)Mockito.never())).releaseAccessToken(ACCESS_TOKEN_ID, (OAuth2Adapter)Mockito.any(OAuth2Adapter.class));
    }

    @Test(expected=UnableToAcquireConnectionException.class)
    public void noAdapterInObjectStore() throws Exception {
        Mockito.when((Object)this.callback.isProtected()).thenReturn((Object)true);
        Mockito.when((Object)this.processor.getAccessTokenId()).thenReturn((Object)ACCESS_TOKEN_ID);
        Mockito.when((Object)this.manager.acquireAccessToken(ACCESS_TOKEN_ID)).thenReturn(null);
        this.interceptor.execute(this.callback, this.adapter, (MessageProcessor)this.processor, this.event);
        ((OAuth2Manager)Mockito.verify(this.manager)).acquireAccessToken(ACCESS_TOKEN_ID);
        ((ProcessInterceptor)Mockito.verify(this.next, (VerificationMode)Mockito.never())).execute(this.callback, (Object)this.adapter, (MessageProcessor)this.processor, this.event);
        ((OAuth2Manager)Mockito.verify(this.manager, (VerificationMode)Mockito.never())).destroyAccessToken(ACCESS_TOKEN_ID, (OAuth2Adapter)Mockito.any(OAuth2Adapter.class));
        ((OAuth2Manager)Mockito.verify(this.manager, (VerificationMode)Mockito.never())).releaseAccessToken(ACCESS_TOKEN_ID, (OAuth2Adapter)Mockito.any(OAuth2Adapter.class));
    }
}

