/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import junit.framework.Assert;
import org.apache.commons.collections.Closure;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.store.ObjectStore;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.RefreshTokenManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.store.InMemoryObjectStore;

public class RefreshTokenManagerTestCase
extends AbstractMuleContextTestCase {
    private static final String NAME = "connector";
    private final int TIMEOUT = 1000;
    private final String ACCESS_TOKEN_ID = "accessTokenId";
    private RefreshTokenManager refreshTokenManager;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.refreshTokenManager = (RefreshTokenManager)muleContext.getRegistry().lookupObject(RefreshTokenManager.class);
    }

    @Test
    public void dontRefreshConcurrently() throws Exception {
        this.doDontRefreshConcurrently(new Closure(){

            public void execute(Object input) {
                ((RefreshTokenManager)input).setMinRefreshIntervalInMillis(1000);
            }
        });
    }

    @Test
    public void dontRefreshConcurrentlyConfigureStore() throws Exception {
        this.doDontRefreshConcurrently(new Closure(){

            public void execute(Object input) {
                ((RefreshTokenManager)input).setRefreshedTokensStore((ObjectStore)new InMemoryObjectStore());
            }
        });
    }

    @Test(expected=IllegalStateException.class)
    public void configureStoreTwice() throws Exception {
        this.refreshTokenManager.setRefreshedTokensStore((ObjectStore)new InMemoryObjectStore());
        this.refreshTokenManager.setRefreshedTokensStore((ObjectStore)new InMemoryObjectStore());
    }

    @Test(expected=IllegalStateException.class)
    public void configureStoreAfterInit() throws Exception {
        this.refreshTokenManager.setMinRefreshIntervalInMillis(1000);
        OAuth2Adapter adapter = this.getAdapter();
        this.refreshTokenManager.refreshToken(adapter, "accessTokenId");
        this.refreshTokenManager.setRefreshedTokensStore((ObjectStore)new InMemoryObjectStore());
    }

    private void doDontRefreshConcurrently(Closure configureRefreshStoreColsure) throws Exception {
        int THREAD_COUNT = 10;
        final AtomicInteger exceptionCount = new AtomicInteger(0);
        final OAuth2Adapter adapter = this.getAdapter();
        configureRefreshStoreColsure.execute((Object)this.refreshTokenManager);
        Runnable task = new Runnable(){

            @Override
            public void run() {
                try {
                    RefreshTokenManagerTestCase.this.refreshTokenManager.refreshToken(adapter, "accessTokenId");
                }
                catch (Exception e) {
                    exceptionCount.addAndGet(1);
                }
            }
        };
        ArrayList<Thread> threads = new ArrayList<Thread>(10);
        for (int i = 0; i < 10; ++i) {
            Thread thread = new Thread(task);
            threads.add(thread);
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
        Assert.assertEquals((int)0, (int)exceptionCount.get());
        ((OAuth2Adapter)Mockito.verify((Object)adapter, (VerificationMode)Mockito.times((int)1))).refreshAccessToken("accessTokenId");
        Thread.sleep(1000L);
        Mockito.reset((Object[])new OAuth2Adapter[]{adapter});
        this.refreshTokenManager.refreshToken(adapter, "accessTokenId");
        ((OAuth2Adapter)Mockito.verify((Object)adapter, (VerificationMode)Mockito.times((int)1))).refreshAccessToken("accessTokenId");
    }

    private OAuth2Adapter getAdapter() {
        OAuth2Adapter adapter = (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class);
        Mockito.when((Object)adapter.getName()).thenReturn((Object)NAME);
        return adapter;
    }
}

