/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.store.ObjectStore;
import org.mule.api.store.ObjectStoreException;
import org.mule.common.security.oauth.OAuthState;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.security.oauth.BaseOAuthClientFactory;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.TestOAuth2Adapter;
import org.mule.tck.size.SmallTest;
import org.mule.util.store.InMemoryObjectStore;

@RunWith(value=MockitoJUnitRunner.class)
@SmallTest
public class OAuthClientFactoryTestCase {
    private static final String KEY = "key";
    private static final String consumerKey = "consumerKey";
    private static final String consumerSecret = "consumerSecret";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private OAuth2Manager<OAuth2Adapter> manager;
    private TestClientFactory factory;
    @Mock
    private ObjectStore<Serializable> objectStore;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext muleContext;
    private Map<String, Lock> locks;

    @Before
    public void setUp() {
        this.locks = new HashMap<String, Lock>();
        Mockito.when((Object)this.manager.getDefaultUnauthorizedConnector().getConsumerKey()).thenReturn((Object)consumerKey);
        Mockito.when((Object)this.manager.getDefaultUnauthorizedConnector().getConsumerSecret()).thenReturn((Object)consumerSecret);
        Mockito.when((Object)this.manager.getMuleContext()).thenReturn((Object)this.muleContext);
        Mockito.when((Object)this.muleContext.getLockFactory().createLock(Mockito.anyString())).thenAnswer((Answer)new Answer<Lock>(){

            public synchronized Lock answer(InvocationOnMock invocation) throws Throwable {
                String key = invocation.getArguments()[0].toString();
                Lock lock = (Lock)OAuthClientFactoryTestCase.this.locks.get(key);
                if (lock == null) {
                    lock = new ReentrantLock();
                    OAuthClientFactoryTestCase.this.locks.put(key, lock);
                }
                return lock;
            }
        });
        this.factory = (TestClientFactory)((Object)Mockito.spy((Object)((Object)new TestClientFactory(this.manager, this.objectStore))));
    }

    @Test(expected=NotAuthorizedException.class)
    public void makeObjectWithNotExistentKey() throws Exception {
        Mockito.when((Object)this.objectStore.contains((Serializable)((Object)KEY))).thenReturn((Object)false);
        this.factory.makeObject(KEY);
    }

    @Test
    public void makeObject() throws Exception {
        OAuthState state = this.registerState();
        TestOAuth2Adapter connector = (TestOAuth2Adapter)this.factory.makeObject(KEY);
        Assert.assertSame(connector.getManager(), this.manager);
        ((TestClientFactory)((Object)Mockito.verify((Object)((Object)this.factory)))).setCustomAdapterProperties(connector, state);
        ((OAuth2Manager)Mockito.verify(this.manager)).postAuth((OAuth2Adapter)connector, KEY);
        Assert.assertTrue((boolean)connector.wasStarted());
        Assert.assertTrue((boolean)connector.wasInitialised());
        Assert.assertSame((Object)connector.getMuleContext(), (Object)this.muleContext);
        Assert.assertEquals((Object)connector.getConsumerKey(), (Object)consumerKey);
        Assert.assertEquals((Object)connector.getConsumerSecret(), (Object)consumerSecret);
        Assert.assertEquals((Object)connector.getAccessToken(), (Object)state.getAccessToken());
        Assert.assertEquals((Object)connector.getAccessTokenUrl(), (Object)state.getAccessTokenUrl());
        Assert.assertEquals((Object)connector.getAuthorizationUrl(), (Object)state.getAuthorizationUrl());
        Assert.assertEquals((Object)connector.getRefreshToken(), (Object)state.getRefreshToken());
        ((ObjectStore)Mockito.verify(this.objectStore, (VerificationMode)Mockito.never())).remove((Serializable)((Object)KEY));
        ((ObjectStore)Mockito.verify(this.objectStore, (VerificationMode)Mockito.never())).store((Serializable)Mockito.eq((Object)KEY), (Serializable)Mockito.any(OAuthState.class));
    }

    @Test
    public void makeObjectWithOldState() throws Exception {
        final OldOAuthState state = this.registerOldState();
        ((TestClientFactory)((Object)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                OAuthState newState = (OAuthState)invocation.getArguments()[1];
                Assert.assertEquals((Object)newState.getAccessToken(), (Object)state.getAccessToken());
                Assert.assertEquals((Object)newState.getAccessTokenUrl(), (Object)state.getAccessTokenUrl());
                Assert.assertEquals((Object)newState.getAuthorizationUrl(), (Object)state.getAuthorizationUrl());
                Assert.assertEquals((Object)newState.getRefreshToken(), (Object)state.getRefreshToken());
                Assert.assertEquals((Object)newState.getCustomProperty("custom1"), (Object)state.getCustom1());
                Assert.assertEquals((Object)newState.getCustomProperty("custom2"), (Object)state.getCustom2());
                state.setChecked(true);
                return null;
            }
        }).when((Object)this.factory))).setCustomAdapterProperties((OAuth2Adapter)Mockito.any(TestOAuth2Adapter.class), (OAuthState)Mockito.any(OAuthState.class));
        TestOAuth2Adapter connector = (TestOAuth2Adapter)this.factory.makeObject(KEY);
        Assert.assertTrue((boolean)state.isChecked());
        Assert.assertSame(connector.getManager(), this.manager);
        ((OAuth2Manager)Mockito.verify(this.manager)).postAuth((OAuth2Adapter)connector, KEY);
        Assert.assertTrue((boolean)connector.wasStarted());
        Assert.assertTrue((boolean)connector.wasInitialised());
        Assert.assertSame((Object)connector.getMuleContext(), (Object)this.muleContext);
        Assert.assertEquals((Object)connector.getConsumerKey(), (Object)consumerKey);
        Assert.assertEquals((Object)connector.getConsumerSecret(), (Object)consumerSecret);
        Assert.assertEquals((Object)connector.getAccessToken(), (Object)state.getAccessToken());
        Assert.assertEquals((Object)connector.getAccessTokenUrl(), (Object)state.getAccessTokenUrl());
        Assert.assertEquals((Object)connector.getAuthorizationUrl(), (Object)state.getAuthorizationUrl());
        Assert.assertEquals((Object)connector.getRefreshToken(), (Object)state.getRefreshToken());
        ((ObjectStore)Mockito.verify(this.objectStore)).remove((Serializable)((Object)KEY));
        ((ObjectStore)Mockito.verify(this.objectStore)).store((Serializable)Mockito.eq((Object)KEY), (Serializable)Mockito.any(OAuthState.class));
    }

    @Test(expected=IllegalArgumentException.class)
    public void destroyWithIllegalValueType() throws Exception {
        this.factory.destroyObject(KEY, (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class));
    }

    @Test
    public void destroy() throws Exception {
        TestOAuth2Adapter adapter = new TestOAuth2Adapter(this.manager);
        this.factory.destroyObject(KEY, adapter);
        Assert.assertTrue((boolean)adapter.wasStopped());
        Assert.assertTrue((boolean)adapter.wasDisposed());
    }

    @Test(expected=IllegalArgumentException.class)
    public void validateObjectOfIllegalType() throws Exception {
        this.factory.validateObject(KEY, (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class));
    }

    @Test
    public void validateObject() throws Exception {
        OAuthState state = this.registerState();
        TestOAuth2Adapter adapter = new TestOAuth2Adapter(this.manager);
        adapter.setAccessToken(state.getAccessToken());
        adapter.setRefreshToken(state.getRefreshToken());
        Assert.assertTrue((boolean)this.factory.validateObject(KEY, adapter));
    }

    @Test
    public void validateObjectWithNoAccessToken() throws Exception {
        this.registerState();
        TestOAuth2Adapter adapter = new TestOAuth2Adapter(this.manager);
        adapter.setAccessToken(null);
        Assert.assertFalse((boolean)this.factory.validateObject(KEY, adapter));
    }

    @Test
    public void validateObjectWithWrongAccessToken() throws Exception {
        this.registerState();
        TestOAuth2Adapter adapter = new TestOAuth2Adapter(this.manager);
        adapter.setAccessToken("I'm wrong");
        Assert.assertFalse((boolean)this.factory.validateObject(KEY, adapter));
    }

    @Test
    public void validateObjectWithNoRefreshTokenButStateThatDoes() throws Exception {
        OAuthState state = this.registerState();
        TestOAuth2Adapter adapter = new TestOAuth2Adapter(this.manager);
        adapter.setAccessToken(state.getAccessToken());
        adapter.setRefreshToken(null);
        Assert.assertFalse((boolean)this.factory.validateObject(KEY, adapter));
    }

    @Test
    public void validateObjectWithNoRefreshTokenButStateThatDoesntEither() throws Exception {
        OAuthState state = this.registerState();
        TestOAuth2Adapter adapter = new TestOAuth2Adapter(this.manager);
        adapter.setAccessToken(state.getAccessToken());
        adapter.setRefreshToken(null);
        state.setRefreshToken(null);
        Assert.assertTrue((boolean)this.factory.validateObject(KEY, adapter));
    }

    @Test
    public void validateObjectWithWrongRefresh() throws Exception {
        OAuthState state = this.registerState();
        TestOAuth2Adapter adapter = new TestOAuth2Adapter(this.manager);
        adapter.setAccessToken(state.getAccessToken());
        adapter.setRefreshToken("I'm wrong");
        Assert.assertFalse((boolean)this.factory.validateObject(KEY, adapter));
    }

    @Test
    public void validateObjectWithNotExistingKey() throws Exception {
        Assert.assertFalse((boolean)this.factory.validateObject("fakeKey", new TestOAuth2Adapter(this.manager)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void passivateWithWrongValueType() throws Exception {
        this.factory.passivateObject(KEY, (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class));
    }

    @Test
    public void passivateExisting() throws Exception {
        OAuthState state = this.registerState();
        TestOAuth2Adapter adapter = new TestOAuth2Adapter(this.manager);
        adapter.setAccessToken("new access token");
        adapter.setAccessTokenUrl("access token url");
        adapter.setAuthorizationUrl("authorization url");
        adapter.setRefreshToken("refresh token");
        this.factory.passivateObject(KEY, adapter);
        Assert.assertEquals((Object)adapter.getAccessToken(), (Object)state.getAccessToken());
        Assert.assertEquals((Object)adapter.getAccessTokenUrl(), (Object)state.getAccessTokenUrl());
        Assert.assertEquals((Object)adapter.getAuthorizationUrl(), (Object)state.getAuthorizationUrl());
        Assert.assertEquals((Object)adapter.getRefreshToken(), (Object)state.getRefreshToken());
        ((ObjectStore)Mockito.verify(this.objectStore)).remove((Serializable)((Object)KEY));
        ((TestClientFactory)((Object)Mockito.verify((Object)((Object)this.factory)))).setCustomStateProperties(adapter, state);
        ((ObjectStore)Mockito.verify(this.objectStore)).store((Serializable)((Object)KEY), (Serializable)state);
    }

    @Test
    public void passivateUnexisting() throws Exception {
        Mockito.when((Object)this.objectStore.contains((Serializable)((Object)KEY))).thenReturn((Object)false);
        final TestOAuth2Adapter adapter = this.getTesteAdapter();
        this.factory.passivateObject(KEY, adapter);
        ((ObjectStore)Mockito.verify(this.objectStore, (VerificationMode)Mockito.never())).retrieve((Serializable)((Object)KEY));
        ((ObjectStore)Mockito.verify(this.objectStore, (VerificationMode)Mockito.never())).remove((Serializable)((Object)KEY));
        ((ObjectStore)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                OAuthState state = (OAuthState)invocation.getArguments()[1];
                Assert.assertEquals((Object)adapter.getAccessToken(), (Object)state.getAccessToken());
                Assert.assertEquals((Object)adapter.getAccessTokenUrl(), (Object)state.getAccessTokenUrl());
                Assert.assertEquals((Object)adapter.getAuthorizationUrl(), (Object)state.getAuthorizationUrl());
                Assert.assertEquals((Object)adapter.getRefreshToken(), (Object)state.getRefreshToken());
                return null;
            }
        }).when(this.objectStore)).store((Serializable)Mockito.eq((Object)KEY), (Serializable)Mockito.any(OAuthState.class));
    }

    @Test
    public void objectStoreAtomicity() throws Exception {
        OAuthState state = this.registerState();
        this.objectStore = new InMemoryObjectStore();
        this.objectStore.store((Serializable)((Object)KEY), (Serializable)state);
        this.factory = new TestClientFactory(this.manager, this.objectStore);
        final AtomicInteger rejectedAccessAttemps = new AtomicInteger(0);
        final CountDownLatch latch = new CountDownLatch(4);
        final ReentrantLock lock = new ReentrantLock();
        Mockito.when((Object)this.muleContext.getLockFactory().createLock(Mockito.anyString())).thenAnswer((Answer)new Answer<Lock>(){
            private boolean first = true;

            public synchronized Lock answer(InvocationOnMock invocation) throws Throwable {
                if (this.first) {
                    this.first = false;
                } else {
                    rejectedAccessAttemps.addAndGet(1);
                }
                latch.countDown();
                return lock;
            }
        });
        final TestOAuth2Adapter adapter = this.getTesteAdapter();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    OAuthClientFactoryTestCase.this.factory.passivateObject(OAuthClientFactoryTestCase.KEY, adapter);
                    OAuthClientFactoryTestCase.this.factory.makeObject(OAuthClientFactoryTestCase.KEY);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        new Thread(r).start();
        new Thread(r).start();
        latch.await(5L, TimeUnit.SECONDS);
        Assert.assertEquals((long)3L, (long)rejectedAccessAttemps.get());
    }

    private TestOAuth2Adapter getTesteAdapter() {
        TestOAuth2Adapter adapter = new TestOAuth2Adapter(this.manager);
        adapter.setAccessToken("new access token");
        adapter.setAccessTokenUrl("access token url");
        adapter.setAuthorizationUrl("authorization url");
        adapter.setRefreshToken("refresh token");
        return adapter;
    }

    private OAuthState registerState() throws ObjectStoreException {
        OAuthState state = new OAuthState();
        state.setAccessToken("accessToken");
        state.setAccessTokenUrl("accessTokenUrl");
        state.setAuthorizationUrl("authorizationUrl");
        state.setCustomProperty("custom1", "custom1");
        state.setCustomProperty("custom2", "custom2");
        state.setRefreshToken("refreshToken");
        Mockito.when((Object)this.objectStore.contains((Serializable)((Object)KEY))).thenReturn((Object)true);
        Mockito.when((Object)this.objectStore.retrieve((Serializable)((Object)KEY))).thenReturn((Object)state);
        return state;
    }

    private OldOAuthState registerOldState() throws ObjectStoreException {
        OldOAuthState state = new OldOAuthState();
        state.setAccessToken("accessToken");
        state.setAccessTokenUrl("accessTokenUrl");
        state.setAuthorizationUrl("authorizationUrl");
        state.setRefreshToken("refreshToken");
        state.setCustom1("custom1");
        state.setCustom2("custom2");
        Mockito.when((Object)this.objectStore.contains((Serializable)((Object)KEY))).thenReturn((Object)true);
        Mockito.when((Object)this.objectStore.retrieve((Serializable)((Object)KEY))).thenReturn((Object)state);
        return state;
    }

    private class OldOAuthState
    implements Serializable {
        private static final long serialVersionUID = 8840821869504383401L;
        private String accessToken;
        private String authorizationUrl;
        private String accessTokenUrl;
        private String refreshToken;
        private String custom1;
        private String custom2;
        private boolean checked = false;

        private OldOAuthState() {
        }

        public String getAccessToken() {
            return this.accessToken;
        }

        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        public String getAuthorizationUrl() {
            return this.authorizationUrl;
        }

        public void setAuthorizationUrl(String authorizationUrl) {
            this.authorizationUrl = authorizationUrl;
        }

        public String getAccessTokenUrl() {
            return this.accessTokenUrl;
        }

        public void setAccessTokenUrl(String accessTokenUrl) {
            this.accessTokenUrl = accessTokenUrl;
        }

        public String getRefreshToken() {
            return this.refreshToken;
        }

        public void setRefreshToken(String refreshToken) {
            this.refreshToken = refreshToken;
        }

        public String getCustom1() {
            return this.custom1;
        }

        public void setCustom1(String custom1) {
            this.custom1 = custom1;
        }

        public String getCustom2() {
            return this.custom2;
        }

        public void setCustom2(String custom2) {
            this.custom2 = custom2;
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }
    }

    private class TestClientFactory
    extends BaseOAuthClientFactory {
        public TestClientFactory(OAuth2Manager<OAuth2Adapter> manager, ObjectStore<Serializable> objectStore) {
            super(manager, objectStore);
        }

        protected Class<? extends OAuth2Adapter> getAdapterClass() {
            return TestOAuth2Adapter.class;
        }

        protected void setCustomAdapterProperties(OAuth2Adapter adapter, OAuthState state) {
        }

        protected void setCustomStateProperties(OAuth2Adapter adapter, OAuthState state) {
        }
    }
}

