/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.devkit.capability.ModuleCapability;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.api.store.ObjectStore;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.RefreshTokenManager;
import org.mule.security.oauth.TestOAuth2Manager;
import org.mule.security.oauth.util.HttpUtil;
import org.mule.security.oauth.util.OAuthResponseParser;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OAuth2ManagerTestCase {
    private static final String SCOPE = "<<myScope>>";
    private static final String ACCESS_TOKEN_ID = "accessTokenId";
    private TestOAuth2Manager manager;
    @Mock
    private ObjectStore<Serializable> accessTokenObjectStore = null;
    private MuleContext muleContext = null;
    @Mock
    private KeyedPoolableObjectFactory<String, OAuth2Adapter> objectFactory = null;
    @Mock(extraInterfaces={Initialisable.class, Startable.class, Stoppable.class, Disposable.class, MuleContextAware.class})
    private OAuth2Adapter adapter;
    @Mock
    private GenericKeyedObjectPool<String, OAuth2Adapter> accessTokenPool;
    @Mock
    private HttpUtil httpUtil;
    @Mock
    private OAuthResponseParser oauthResponseParser;
    @Mock
    private Transformer transformer;
    @Mock
    private RefreshTokenManager refreshTokenManager;
    @Mock
    private MuleEvent event;

    @Before
    public void setUp() throws Exception {
        this.muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)this.muleContext.getRegistry().lookupObject((String)Matchers.eq((Object)"_defaultUserObjectStore"))).thenReturn(this.accessTokenObjectStore);
        Mockito.when((Object)this.muleContext.getRegistry().lookupTransformer((DataType)Matchers.any(DataType.class), (DataType)Matchers.any(DataType.class))).thenReturn((Object)this.transformer);
        this.manager = (TestOAuth2Manager)((Object)Mockito.spy((Object)((Object)new TestOAuth2Manager(this.objectFactory, this.adapter))));
        this.manager.setMuleContext(this.muleContext);
        this.manager.setHttpUtil(this.httpUtil);
        this.manager.setOauthResponseParser(this.oauthResponseParser);
        this.manager.setScope(SCOPE);
        this.manager.setRefreshTokenManager(this.refreshTokenManager);
        this.manager.initialise();
        this.manager.start();
    }

    @Test
    public void initialize() throws InitialisationException {
        Assert.assertSame((Object)this.manager.getAccessTokenObjectStore(), this.accessTokenObjectStore);
        ((TestOAuth2Manager)((Object)Mockito.verify((Object)((Object)this.manager)))).createPoolFactory((OAuth2Manager<OAuth2Adapter>)this.manager, this.accessTokenObjectStore);
        ((Initialisable)Mockito.verify((Object)((Initialisable)this.adapter))).initialise();
    }

    @Test
    public void start() throws MuleException {
        ((Startable)Mockito.verify((Object)((Startable)this.adapter))).start();
    }

    @Test
    public void stop() throws MuleException {
        this.manager.stop();
        ((Stoppable)Mockito.verify((Object)((Stoppable)this.adapter))).stop();
    }

    @Test
    public void dispose() throws MuleException {
        this.manager.dispose();
        ((Disposable)Mockito.verify((Object)((Disposable)this.adapter))).dispose();
    }

    @Test
    public void createAdapter() throws Exception {
        String verifier = "verifier";
        String authorizationUrl = "authorizationUrl";
        String accessTokenUrl = "accessTokenUrl";
        Mockito.when((Object)this.event.getFlowVariable("_OAUTH_AUTHORIZATION_URL")).thenReturn((Object)"authorizationUrl");
        Mockito.when((Object)this.event.getFlowVariable("_OAUTH_ACCESS_TOKEN_URL")).thenReturn((Object)"accessTokenUrl");
        Mockito.when((Object)this.adapter.getConsumerKey()).thenReturn((Object)"consumerKey");
        Mockito.when((Object)this.adapter.getConsumerSecret()).thenReturn((Object)"consumerSecret");
        OAuth2Adapter adapter = this.manager.createAdapter(this.event, "verifier");
        Assert.assertSame((Object)adapter, (Object)adapter);
        ((OAuth2Adapter)Mockito.verify((Object)adapter)).setOauthVerifier((String)Matchers.eq((Object)"verifier"));
        ((OAuth2Adapter)Mockito.verify((Object)adapter)).setAuthorizationUrl("authorizationUrl");
        ((OAuth2Adapter)Mockito.verify((Object)adapter)).setAccessTokenUrl("accessTokenUrl");
        ((OAuth2Adapter)Mockito.verify((Object)adapter)).setConsumerKey((String)Matchers.eq((Object)adapter.getConsumerKey()));
        ((OAuth2Adapter)Mockito.verify((Object)adapter)).setConsumerSecret((String)Matchers.eq((Object)adapter.getConsumerSecret()));
        ((TestOAuth2Manager)((Object)Mockito.verify((Object)((Object)this.manager)))).setCustomProperties(adapter);
        ((MuleContextAware)Mockito.verify((Object)((MuleContextAware)adapter), (VerificationMode)Mockito.atLeastOnce())).setMuleContext(this.muleContext);
    }

    @Test
    public void buildAuthorizeUrl() throws Exception {
        LinkedHashMap<String, String> extraParameters = new LinkedHashMap<String, String>();
        extraParameters.put("extra1", "extra1");
        extraParameters.put("extra2", "extra2");
        String authorizationUrl = "authorizationUrl";
        String redirectUri = "redirectUri";
        Mockito.when((Object)this.adapter.getAuthorizationUrl()).thenReturn((Object)"authorizationUrl");
        Mockito.when((Object)this.adapter.getConsumerKey()).thenReturn((Object)"consumerKey");
        Assert.assertEquals((Object)URLDecoder.decode(this.manager.buildAuthorizeUrl(extraParameters, null, "redirectUri"), "UTF-8"), (Object)"authorizationUrl?response_type=code&client_id=consumerKey&scope=<<myScope>>&extra1=extra1&extra2=extra2&redirect_uri=redirectUri");
        Assert.assertEquals((Object)URLDecoder.decode(this.manager.buildAuthorizeUrl(extraParameters, "custom", "redirectUri"), "UTF-8"), (Object)"custom?response_type=code&client_id=consumerKey&scope=<<myScope>>&extra1=extra1&extra2=extra2&redirect_uri=redirectUri");
    }

    @Test
    public void fetchAccessToken() throws Exception {
        String accessTokenUrl = "accessTokenUrl";
        Mockito.when((Object)this.adapter.getAccessTokenUrl()).thenReturn((Object)"accessTokenUrl");
        String oauthVerifier = "oauthVerifier";
        String consumerKey = "consumerKey";
        String consumerSecret = "consumerSecret";
        String redirectUri = "redirectUri";
        String response = "response";
        String requestBody = "code=oauthVerifier&client_id=consumerKey&client_secret=consumerSecret&grant_type=authorization_code&redirect_uri=redirectUri";
        Pattern accessTokenPattern = Pattern.compile(".");
        Pattern expirationPattern = Pattern.compile(".");
        Pattern refreshTokenPattern = Pattern.compile(".");
        String accessToken = "accessToken";
        String refreshToken = "refreshToken";
        Date expiration = new Date();
        Mockito.when((Object)this.adapter.getOauthVerifier()).thenReturn((Object)"oauthVerifier");
        Mockito.when((Object)this.adapter.getConsumerKey()).thenReturn((Object)"consumerKey");
        Mockito.when((Object)this.adapter.getConsumerSecret()).thenReturn((Object)"consumerSecret");
        Mockito.when((Object)this.adapter.getAccessCodePattern()).thenReturn((Object)accessTokenPattern);
        Mockito.when((Object)this.adapter.getRefreshTokenPattern()).thenReturn((Object)refreshTokenPattern);
        Mockito.when((Object)this.adapter.getExpirationTimePattern()).thenReturn((Object)expirationPattern);
        Mockito.when((Object)this.httpUtil.post(this.manager.getDefaultUnauthorizedConnector().getAccessTokenUrl(), "code=oauthVerifier&client_id=consumerKey&client_secret=consumerSecret&grant_type=authorization_code&redirect_uri=redirectUri")).thenReturn((Object)"response");
        Mockito.when((Object)this.oauthResponseParser.extractAccessCode(accessTokenPattern, "response")).thenReturn((Object)"accessToken");
        Mockito.when((Object)this.oauthResponseParser.extractExpirationTime(expirationPattern, "response")).thenReturn((Object)expiration);
        Mockito.when((Object)this.oauthResponseParser.extractRefreshToken(refreshTokenPattern, "response")).thenReturn((Object)"refreshToken");
        this.manager.fetchAccessToken(this.adapter, "redirectUri");
        ((HttpUtil)Mockito.verify((Object)this.httpUtil)).post(this.manager.getDefaultUnauthorizedConnector().getAccessTokenUrl(), "code=oauthVerifier&client_id=consumerKey&client_secret=consumerSecret&grant_type=authorization_code&redirect_uri=redirectUri");
        ((OAuthResponseParser)Mockito.verify((Object)this.oauthResponseParser)).extractAccessCode(accessTokenPattern, "response");
        ((OAuth2Adapter)Mockito.verify((Object)this.adapter)).setAccessToken("accessToken");
        ((OAuth2Adapter)Mockito.verify((Object)this.adapter)).setExpiration(expiration);
        ((OAuth2Adapter)Mockito.verify((Object)this.adapter)).setRefreshToken("refreshToken");
        ((OAuth2Adapter)Mockito.verify((Object)this.adapter)).postAuth();
        ((TestOAuth2Manager)((Object)Mockito.verify((Object)((Object)this.manager)))).fetchCallbackParameters(this.adapter, "response");
    }

    @Test
    public void refreshAccessToken() throws Exception {
        String accessTokenUrl = "accessTokenUrl";
        Mockito.when((Object)this.adapter.getAccessTokenUrl()).thenReturn((Object)"accessTokenUrl");
        String oauthVerifier = "oauthVerifier";
        String consumerKey = "consumerKey";
        String consumerSecret = "consumerSecret";
        String response = "response";
        String requestBody = "grant_type=refresh_token&client_id=consumerKey&client_secret=consumerSecret&refresh_token=refreshToken";
        Pattern accessTokenPattern = Pattern.compile(".");
        Pattern expirationPattern = Pattern.compile(".");
        Pattern refreshTokenPattern = Pattern.compile(".");
        String accessToken = "accessToken";
        String refreshToken = "refreshToken";
        Date expiration = new Date();
        Mockito.when((Object)this.adapter.getOauthVerifier()).thenReturn((Object)"oauthVerifier");
        Mockito.when((Object)this.adapter.getConsumerKey()).thenReturn((Object)"consumerKey");
        Mockito.when((Object)this.adapter.getConsumerSecret()).thenReturn((Object)"consumerSecret");
        Mockito.when((Object)this.adapter.getAccessCodePattern()).thenReturn((Object)accessTokenPattern);
        Mockito.when((Object)this.adapter.getRefreshTokenPattern()).thenReturn((Object)refreshTokenPattern);
        Mockito.when((Object)this.adapter.getExpirationTimePattern()).thenReturn((Object)expirationPattern);
        Mockito.when((Object)this.adapter.getRefreshToken()).thenReturn((Object)"refreshToken");
        Mockito.when((Object)this.httpUtil.post(this.manager.getDefaultUnauthorizedConnector().getAccessTokenUrl(), "grant_type=refresh_token&client_id=consumerKey&client_secret=consumerSecret&refresh_token=refreshToken")).thenReturn((Object)"response");
        Mockito.when((Object)this.oauthResponseParser.extractAccessCode(accessTokenPattern, "response")).thenReturn((Object)"accessToken");
        Mockito.when((Object)this.oauthResponseParser.extractExpirationTime(expirationPattern, "response")).thenReturn((Object)expiration);
        Mockito.when((Object)this.oauthResponseParser.extractRefreshToken(refreshTokenPattern, "response")).thenReturn((Object)"refreshToken");
        this.manager.refreshAccessToken(this.adapter, "accessToken");
        ((OAuth2Adapter)Mockito.verify((Object)this.adapter)).setAccessToken(null);
        ((HttpUtil)Mockito.verify((Object)this.httpUtil)).post(this.manager.getDefaultUnauthorizedConnector().getAccessTokenUrl(), "grant_type=refresh_token&client_id=consumerKey&client_secret=consumerSecret&refresh_token=refreshToken");
        ((OAuthResponseParser)Mockito.verify((Object)this.oauthResponseParser)).extractAccessCode(accessTokenPattern, "response");
        ((OAuth2Adapter)Mockito.verify((Object)this.adapter)).setAccessToken("accessToken");
        ((OAuth2Adapter)Mockito.verify((Object)this.adapter)).setExpiration(expiration);
        ((OAuth2Adapter)Mockito.verify((Object)this.adapter)).setRefreshToken("refreshToken");
        ((OAuth2Adapter)Mockito.verify((Object)this.adapter)).postAuth();
        ((TestOAuth2Manager)((Object)Mockito.verify((Object)((Object)this.manager)))).fetchCallbackParameters(this.adapter, "response");
    }

    @Test(expected=IllegalStateException.class)
    public void refreshWithoutToken() throws Exception {
        this.manager.refreshAccessToken(this.adapter, "myToken");
    }

    @Test
    public void hasBeenAuthorized() throws NotAuthorizedException {
        Mockito.when((Object)this.adapter.getAccessToken()).thenReturn((Object)ACCESS_TOKEN_ID);
        this.manager.hasBeenAuthorized(this.adapter);
    }

    @Test(expected=NotAuthorizedException.class)
    public void hasBeenAuthorizedFailure() throws NotAuthorizedException {
        this.manager.hasBeenAuthorized(this.adapter);
    }

    @Test
    public void capabilities() {
        for (ModuleCapability capability : ModuleCapability.values()) {
            if (capability == ModuleCapability.LIFECYCLE_CAPABLE || capability == ModuleCapability.OAUTH2_CAPABLE || capability == ModuleCapability.OAUTH_ACCESS_TOKEN_MANAGEMENT_CAPABLE) {
                Assert.assertTrue((boolean)this.manager.isCapableOf(capability));
                continue;
            }
            Assert.assertFalse((boolean)this.manager.isCapableOf(capability));
        }
    }

    @Test
    public void postAuthNoFailures() throws Exception {
        this.manager.postAuth(this.adapter, ACCESS_TOKEN_ID);
        ((OAuth2Adapter)Mockito.verify((Object)this.adapter)).postAuth();
    }

    @Test
    public void postAuthWithRefreshableException() throws Exception {
        ((OAuth2Adapter)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                Mockito.reset((Object[])new OAuth2Adapter[]{OAuth2ManagerTestCase.this.adapter});
                throw new FileNotFoundException();
            }
        }).when((Object)this.adapter)).postAuth();
        this.manager.postAuth(this.adapter, ACCESS_TOKEN_ID);
        ((RefreshTokenManager)Mockito.verify((Object)this.refreshTokenManager)).refreshToken(this.adapter, ACCESS_TOKEN_ID);
        ((KeyedPoolableObjectFactory)Mockito.verify(this.objectFactory)).passivateObject((Object)ACCESS_TOKEN_ID, (Object)this.adapter);
    }

    @Test(expected=FileNotFoundException.class)
    public void postAuthWithRefreshableExceptionFailsAgain() throws Exception {
        ((OAuth2Adapter)Mockito.doThrow(FileNotFoundException.class).when((Object)this.adapter)).postAuth();
        this.manager.postAuth(this.adapter, ACCESS_TOKEN_ID);
        ((RefreshTokenManager)Mockito.verify((Object)this.refreshTokenManager)).refreshToken(this.adapter, ACCESS_TOKEN_ID);
        ((ObjectStore)Mockito.verify(this.accessTokenObjectStore)).store((Serializable)((Object)ACCESS_TOKEN_ID), (Serializable)this.adapter);
    }

    @Test(expected=FileNotFoundException.class)
    public void postAuthWithRefreshableExceptionButNoAccessTokenId() throws Exception {
        ((OAuth2Adapter)Mockito.doThrow(FileNotFoundException.class).when((Object)this.adapter)).postAuth();
        this.manager.postAuth(this.adapter, null);
        ((RefreshTokenManager)Mockito.verify((Object)this.refreshTokenManager, (VerificationMode)Mockito.never())).refreshToken(this.adapter, Matchers.anyString());
    }

    @Test(expected=RuntimeException.class)
    public void postAuthWithNonRefreshableException() throws Exception {
        ((OAuth2Adapter)Mockito.doThrow(RuntimeException.class).when((Object)this.adapter)).postAuth();
        this.manager.postAuth(this.adapter, ACCESS_TOKEN_ID);
        ((RefreshTokenManager)Mockito.verify((Object)this.refreshTokenManager, (VerificationMode)Mockito.never())).refreshToken(this.adapter, Matchers.anyString());
    }

    @Test
    public void closeTokenPool() throws Exception {
        this.manager.setAccessTokenPool(this.accessTokenPool);
        this.manager.dispose();
        ((GenericKeyedObjectPool)Mockito.verify(this.accessTokenPool)).close();
    }
}

