/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import oauth.signpost.OAuthConsumer;
import oauth.signpost.basic.DefaultOAuthConsumer;
import oauth.signpost.signature.AuthorizationHeaderSigningStrategy;
import oauth.signpost.signature.HmacSha1MessageSigner;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.api.context.MuleContextAware;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.Startable;
import org.mule.api.lifecycle.Stoppable;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.security.oauth.BaseOAuth1Manager;
import org.mule.security.oauth.OAuth1Adapter;
import org.mule.security.oauth.callback.RestoreAccessTokenCallback;
import org.mule.tck.size.SmallTest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class OAuth1ManagerTestCase {
    @Spy
    private TestOAuth1Manager manager = new TestOAuth1Manager();
    @Mock(extraInterfaces={Initialisable.class, Startable.class, Stoppable.class, Disposable.class, MuleContextAware.class})
    private OAuth1Adapter adapter = null;
    @Mock
    private OAuthConsumer consumer;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.adapter.getConsumer()).thenReturn((Object)this.consumer);
    }

    @Test
    public void restoreTokenWithCallback() {
        RestoreAccessTokenCallback callback = (RestoreAccessTokenCallback)Mockito.mock(RestoreAccessTokenCallback.class);
        Mockito.when((Object)this.adapter.getOauthRestoreAccessToken()).thenReturn((Object)callback);
        String accessToken = "accessToken";
        Mockito.when((Object)callback.getAccessToken()).thenReturn((Object)"accessToken");
        Assert.assertTrue((boolean)this.manager.restoreAccessToken(this.adapter));
        ((RestoreAccessTokenCallback)Mockito.verify((Object)callback)).restoreAccessToken();
        ((OAuth1Adapter)Mockito.verify((Object)this.adapter)).setAccessToken((String)Mockito.eq((Object)"accessToken"));
    }

    @Test
    public void restoreTokenWithoutCallback() {
        Assert.assertFalse((boolean)this.manager.restoreAccessToken(this.adapter));
    }

    @Test
    public void reset() {
        this.manager.reset(this.adapter);
        ((OAuth1Adapter)Mockito.verify((Object)this.adapter)).setAccessToken(null);
        ((OAuth1Adapter)Mockito.verify((Object)this.adapter)).setAccessTokenSecret(null);
        ((OAuthConsumer)Mockito.verify((Object)this.consumer)).setTokenWithSecret(null, null);
    }

    @Test
    public void newConsumer() {
        Mockito.reset((Object[])new OAuth1Adapter[]{this.adapter});
        String consumerKey = "consumerKey";
        String consumerSecret = "consumerSecret";
        HmacSha1MessageSigner signer = new HmacSha1MessageSigner();
        AuthorizationHeaderSigningStrategy signingStrategy = new AuthorizationHeaderSigningStrategy();
        Mockito.when((Object)this.adapter.getConsumerKey()).thenReturn((Object)"consumerKey");
        Mockito.when((Object)this.adapter.getConsumerSecret()).thenReturn((Object)"consumerSecret");
        Mockito.when((Object)this.adapter.getSigningStrategy()).thenReturn((Object)signingStrategy);
        Mockito.when((Object)this.adapter.getMessageSigner()).thenReturn((Object)signer);
        DefaultOAuthConsumer consumer = (DefaultOAuthConsumer)this.manager.getConsumer(this.adapter);
        Assert.assertEquals((Object)consumer.getConsumerKey(), (Object)"consumerKey");
        Assert.assertEquals((Object)consumer.getConsumerSecret(), (Object)"consumerSecret");
        ((OAuth1Adapter)Mockito.verify((Object)this.adapter)).setConsumer((OAuthConsumer)consumer);
    }

    @Test(expected=NotAuthorizedException.class)
    public void notAuthorized() throws Exception {
        this.manager.hasBeenAuthorized(this.adapter);
        ((OAuth1Adapter)Mockito.verify((Object)this.adapter, (VerificationMode)Mockito.times((int)2))).getAccessToken();
    }

    @Test
    public void authorizhedWithoutRestore() throws Exception {
        Mockito.when((Object)this.adapter.getAccessToken()).thenReturn((Object)"accessToken");
        this.manager.hasBeenAuthorized(this.adapter);
    }

    @Test
    public void authorizeWithRestore() throws Exception {
        Mockito.when((Object)this.adapter.getAccessToken()).thenReturn(null).thenReturn((Object)"accessToken");
        this.manager.hasBeenAuthorized(this.adapter);
    }

    private class TestOAuth1Manager
    extends BaseOAuth1Manager {
        private Logger logger = LoggerFactory.getLogger(TestOAuth1Manager.class);

        private TestOAuth1Manager() {
        }

        protected Logger getLogger() {
            return this.logger;
        }
    }
}

