/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import junit.framework.Assert;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.api.store.ObjectStore;
import org.mule.api.transport.PropertyScope;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.OAuth2Manager;
import org.mule.security.oauth.TestOAuth2Manager;
import org.mule.security.oauth.processor.OAuth2FetchAccessTokenMessageProcessor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.util.store.InMemoryObjectStore;

public class FetchAccessTokenTestCase
extends AbstractMuleContextTestCase
implements Runnable {
    private static final String accessToken = "MY_ACCESS_TOKEN";
    private MuleEvent event;
    private TestOAuth2Manager manager;
    private OAuth2FetchAccessTokenMessageProcessor processor;
    private OAuth2Adapter adapter;
    private ObjectStore<Serializable> objectStore;
    private CountDownLatch latch;
    private Exception exception;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.adapter = (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class);
        this.objectStore = new InMemoryObjectStore();
        this.event = FetchAccessTokenTestCase.getTestEvent((Object)"");
        this.event.getMessage().setProperty("state", (Object)"<<MULE_EVENT_ID=whatever>>", PropertyScope.INBOUND);
        this.latch = new CountDownLatch(1);
        this.exception = null;
        this.manager = new TestOAuth2Manager((KeyedPoolableObjectFactory<String, OAuth2Adapter>)((KeyedPoolableObjectFactory)Mockito.mock(KeyedPoolableObjectFactory.class)), this.adapter);
        this.manager.setAccessTokenObjectStore(this.objectStore);
        this.processor = new OAuth2FetchAccessTokenMessageProcessor((OAuth2Manager)this.manager, accessToken);
        this.processor.setMuleContext(muleContext);
        this.processor.setAccessTokenId(accessToken);
    }

    @Test
    public void inMemoryObjectStore() throws Exception {
        this.objectStore.store((Serializable)((Object)"whatever-authorization-event"), (Serializable)this.event);
        Thread t = new Thread(this);
        t.start();
        if (this.latch.await(1L, TimeUnit.SECONDS)) {
            if (this.exception != null) {
                throw this.exception;
            }
        } else {
            t.interrupt();
            Assert.fail((String)"timeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.processor.process(this.event);
        }
        catch (Exception e) {
            this.exception = e;
        }
        finally {
            this.latch.countDown();
        }
    }
}

