/*
 * Decompiled with CFR 0.152.
 */
package org.mule.security.oauth;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.devkit.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.filter.Filter;
import org.mule.config.spring.SpringXmlConfigurationBuilder;
import org.mule.security.oauth.OAuth2Adapter;
import org.mule.security.oauth.callback.ProcessCallback;
import org.mule.security.oauth.process.RefreshTokenProcessInterceptor;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

public class ConcurrentRefreshTest
extends AbstractMuleContextTestCase {
    private final String accessTokenId = "myToken";
    private final String tokenUrl = "tokenUrl";
    private MessageProcessor mp;
    private MuleEvent event;
    private OAuth2Adapter adapter;
    private ConcurrentProcessCallback callback;

    protected ConfigurationBuilder getBuilder() throws Exception {
        return new SpringXmlConfigurationBuilder(new String[0]);
    }

    @Before
    public void setUp() throws Exception {
        this.mp = (MessageProcessor)Mockito.mock(MessageProcessor.class);
        this.event = (MuleEvent)Mockito.mock(MuleEvent.class);
        this.adapter = (OAuth2Adapter)Mockito.mock(OAuth2Adapter.class);
        this.callback = new ConcurrentProcessCallback("myToken");
        Mockito.when((Object)this.adapter.getRefreshToken()).thenReturn((Object)"someRefreshToken");
        Mockito.when((Object)this.adapter.getAccessTokenUrl()).thenReturn((Object)this.tokenUrl);
    }

    @Test
    public void concurrentRefresh() throws Exception {
        int threadCount = 100;
        TestProcessInterceptor interceptor = new TestProcessInterceptor();
        final RefreshTokenProcessInterceptor refresh = new RefreshTokenProcessInterceptor((ProcessInterceptor)interceptor, muleContext);
        ((OAuth2Adapter)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                ConcurrentRefreshTest.this.callback.setRefreshed(true);
                return null;
            }
        }).when((Object)this.adapter)).refreshAccessToken("myToken");
        final CountDownLatch latch = new CountDownLatch(100);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                try {
                    refresh.execute((ProcessCallback)ConcurrentRefreshTest.this.callback, ConcurrentRefreshTest.this.adapter, ConcurrentRefreshTest.this.mp, ConcurrentRefreshTest.this.event);
                    latch.countDown();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        for (int i = 0; i < 100; ++i) {
            new Thread(run).start();
        }
        latch.await();
        ((OAuth2Adapter)Mockito.verify((Object)this.adapter)).refreshAccessToken("myToken");
    }

    private class ConcurrentProcessCallback
    extends ProcessCallback<String, OAuth2Adapter> {
        private int count = 0;
        private boolean refreshed = false;

        public ConcurrentProcessCallback(String accessTokenId) {
            this.setAccessTokenId(accessTokenId);
        }

        public String process(OAuth2Adapter object) throws Exception {
            if (!this.refreshed && this.count >= 20) {
                throw new FileNotFoundException();
            }
            ++this.count;
            return null;
        }

        public List<Class<? extends Exception>> getManagedExceptions() {
            ArrayList<Class<? extends Exception>> list = new ArrayList<Class<? extends Exception>>();
            list.add(FileNotFoundException.class);
            return list;
        }

        public boolean isProtected() {
            return true;
        }

        public void setRefreshed(boolean refreshed) {
            this.refreshed = refreshed;
        }
    }

    private class TestProcessInterceptor
    implements ProcessInterceptor<String, OAuth2Adapter> {
        private TestProcessInterceptor() {
        }

        public String execute(ProcessCallback<String, OAuth2Adapter> callback, OAuth2Adapter under, Filter filter, MuleMessage message) throws Exception {
            return null;
        }

        public String execute(ProcessCallback<String, OAuth2Adapter> callback, OAuth2Adapter under, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
            callback.process(null);
            return null;
        }
    }
}

