/*
 * Decompiled with CFR 0.152.
 */
package org.mule.devkit.processor;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.common.security.oauth.exception.NotAuthorizedException;
import org.mule.devkit.processor.DevkitBasedMessageProcessor;
import org.mule.security.oauth.OnNoTokenPolicy;
import org.mule.security.oauth.OnNoTokenPolicyAware;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DevkitBasedMessageProcessorTest
extends AbstractMuleTestCase {
    @Test
    public void handlesNotAuthorizedExceptionWithFixedModule() throws Exception {
        OnNoTokenPolicyAware policyAware = (OnNoTokenPolicyAware)Mockito.mock(OnNoTokenPolicyAware.class);
        Mockito.when((Object)policyAware.getOnNoTokenPolicy()).thenReturn((Object)OnNoTokenPolicy.STOP_FLOW);
        UnauthorizedProcessor processor = new UnauthorizedProcessor("forbidden");
        processor.setModuleObject(policyAware);
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        MuleEvent responseEvent = processor.process(event);
        Assert.assertThat((String)"event should be filtered because STOP_FLOW was used", (Object)responseEvent, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void handlesNotAuthorizedExceptionWithExpressionModule() throws Exception {
        String expression = "#[policyAware]";
        OnNoTokenPolicyAware policyAware = (OnNoTokenPolicyAware)Mockito.mock(OnNoTokenPolicyAware.class);
        Mockito.when((Object)policyAware.getOnNoTokenPolicy()).thenReturn((Object)OnNoTokenPolicy.STOP_FLOW);
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)muleContext.getExpressionManager().evaluate("#[policyAware]", event, true)).thenReturn((Object)policyAware);
        UnauthorizedProcessor processor = new UnauthorizedProcessor("forbidden");
        processor.setMuleContext(muleContext);
        processor.setModuleObject("#[policyAware]");
        MuleEvent responseEvent = processor.process(event);
        Assert.assertThat((String)"event should be filtered because STOP_FLOW was used", (Object)responseEvent, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testThatProcessMethodCanBeOverridden() throws MuleException {
        DevkitMessageProcessorProxy connectorMessageProcessor = new DevkitMessageProcessorProxy("anyName");
        connectorMessageProcessor.process(null);
        Assert.assertTrue((boolean)connectorMessageProcessor.wasCalled);
    }

    private static class DevkitMessageProcessorProxy
    extends DevkitBasedMessageProcessor {
        boolean wasCalled;

        public DevkitMessageProcessorProxy(String operationName) {
            super(operationName);
        }

        public MuleEvent process(MuleEvent event) throws MuleException {
            this.wasCalled = true;
            return event;
        }

        protected MuleEvent doProcess(MuleEvent event) throws Exception {
            this.wasCalled = false;
            return event;
        }
    }

    private class UnauthorizedProcessor
    extends DevkitBasedMessageProcessor {
        public UnauthorizedProcessor(String operationName) {
            super(operationName);
        }

        protected MuleEvent doProcess(MuleEvent event) throws Exception {
            throw new NotAuthorizedException("unauthorized");
        }
    }
}

