/*
 * Decompiled with CFR 0.152.
 */
package org.msbotframework4j.logging.impl;

import org.apache.commons.lang3.text.StrBuilder;
import org.msbotframework4j.logging.AbstractBotLogger;
import org.msbotframework4j.logging.BotLogEntry;
import org.slf4j.Logger;

public class Slf4jBotLogger
extends AbstractBotLogger {
    private final Logger logger;

    public Slf4jBotLogger(Logger logger) {
        this.logger = logger;
    }

    @Override
    protected void writeToSink(BotLogEntry entry) {
        String logEntry = this.formatLogEntry(entry);
        switch (entry.getSeverity()) {
            case DEBUG: {
                if (!this.logger.isDebugEnabled()) break;
                this.logger.debug(logEntry);
                break;
            }
            case INFO: {
                if (!this.logger.isInfoEnabled()) break;
                this.logger.info(logEntry);
                break;
            }
            case WARNING: {
                if (!this.logger.isWarnEnabled()) break;
                this.logger.warn(logEntry);
                break;
            }
            case ERROR: {
                if (!this.logger.isErrorEnabled()) break;
                this.logger.error(logEntry);
            }
        }
    }

    @Override
    protected String formatLogEntry(BotLogEntry entry) {
        StrBuilder sb = new StrBuilder();
        sb.append(this.getDateFormat().format(entry.getTimestamp()));
        sb.append(entry.getMessage());
        return sb.toString();
    }
}

