/*
 * Decompiled with CFR 0.152.
 */
package org.msbotframework4j.logging;

import java.util.Date;
import org.msbotframework4j.logging.BotLogSeverity;

public final class BotLogEntry {
    private Date timestamp;
    private BotLogSeverity severity;
    private String message;
    private Throwable exception;

    BotLogEntry() {
    }

    public BotLogEntry(BotLogSeverity severity, String message) {
        this(severity, message, null);
    }

    public BotLogEntry(BotLogSeverity severity, Throwable exception) {
        this(severity, null, exception);
    }

    public BotLogEntry(BotLogSeverity severity, String message, Throwable exception) {
        this(new Date(), severity, message, exception);
    }

    public BotLogEntry(Date timestamp, BotLogSeverity severity, String message, Throwable exception) {
        this.timestamp = timestamp == null ? new Date() : timestamp;
        this.severity = severity;
        this.exception = exception;
        this.buildMessage(message);
    }

    void buildMessage(String message) {
        this.message = message == null && this.exception == null ? "" : (message == null ? this.exception.getLocalizedMessage() : (this.exception == null ? message : message + " caused by " + this.exception.getClass().getCanonicalName() + " " + this.exception.getLocalizedMessage()));
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    public BotLogSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(BotLogSeverity severity) {
        this.severity = severity;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setException(Throwable exception) {
        this.exception = exception;
    }
}

