/*
 * Decompiled with CFR 0.152.
 */
package org.msbotframework4j.logging;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.text.StrBuilder;
import org.msbotframework4j.logging.BotLogEntry;
import org.msbotframework4j.logging.BotLogEntryBuilder;
import org.msbotframework4j.logging.BotLogSeverity;
import org.msbotframework4j.logging.BotLogger;

public abstract class AbstractBotLogger
implements BotLogger {
    private static final DateFormat DATE_FORMAT = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");

    @Override
    public void debug(String message) {
        this.log(BotLogSeverity.DEBUG, message, null);
    }

    @Override
    public void debug(String message, Throwable exception) {
        this.log(BotLogSeverity.DEBUG, message, exception);
    }

    @Override
    public void info(String message) {
        this.log(BotLogSeverity.INFO, message, null);
    }

    @Override
    public void info(String message, Throwable exception) {
        this.log(BotLogSeverity.INFO, message, exception);
    }

    @Override
    public void warn(String message) {
        this.log(BotLogSeverity.WARNING, message, null);
    }

    @Override
    public void warn(String message, Throwable exception) {
        this.log(BotLogSeverity.WARNING, message, exception);
    }

    @Override
    public void error(String message) {
        this.log(BotLogSeverity.ERROR, message, null);
    }

    @Override
    public void error(String message, Throwable exception) {
        this.log(BotLogSeverity.ERROR, message, exception);
    }

    @Override
    public void log(BotLogSeverity severity, String message, Throwable exception) {
        this.log(new BotLogEntry(severity, message, exception));
    }

    @Override
    public void log(BotLogEntry entry) {
        this.writeToSink(entry);
    }

    protected String formatLogEntry(BotLogEntry entry) {
        StrBuilder sb = new StrBuilder();
        sb.append(this.getDateFormat().format(entry.getTimestamp()));
        sb.appendFixedWidthPadLeft((Object)entry.getSeverity().getAbbreviation(), 7, ' ');
        sb.appendSeparator(' ').append(entry.getMessage());
        return sb.toString();
    }

    protected DateFormat getDateFormat() {
        return DATE_FORMAT;
    }

    protected abstract void writeToSink(BotLogEntry var1);

    @Override
    public BotLogEntryBuilder composeLogMessage() {
        return new BotLogEntryBuilderImpl(this);
    }

    private class BotLogEntryBuilderImpl
    implements BotLogEntryBuilder {
        private final AbstractBotLogger logger;
        private final StrBuilder sb = new StrBuilder();
        private final BotLogEntry logEntry = new BotLogEntry();

        private BotLogEntryBuilderImpl(AbstractBotLogger logger) {
            this.logger = logger;
        }

        @Override
        public BotLogEntryBuilder appendWhitespaceSeparator() {
            return this.appendSeparator(' ');
        }

        @Override
        public BotLogEntryBuilder appendSeparator(char separator) {
            this.sb.appendSeparator(separator);
            return this;
        }

        @Override
        public BotLogEntryBuilder append(Object obj) {
            this.sb.append(obj);
            return this;
        }

        @Override
        public BotLogEntryBuilder append(String str) {
            this.sb.append(str);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendNewLine() {
            this.sb.appendNewLine();
            return this;
        }

        @Override
        public BotLogEntryBuilder append(int value) {
            this.sb.append(value);
            return this;
        }

        @Override
        public BotLogEntryBuilder append(long value) {
            this.sb.append(value);
            return this;
        }

        @Override
        public BotLogEntryBuilder append(float value) {
            this.sb.append(value);
            return this;
        }

        @Override
        public BotLogEntryBuilder append(double value) {
            this.sb.append(value);
            return this;
        }

        @Override
        public BotLogEntryBuilder append(boolean value) {
            this.sb.append(value);
            return this;
        }

        @Override
        public BotLogEntryBuilder append(char ch) {
            this.sb.append(ch);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendln(Object obj) {
            this.sb.appendln(obj);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendln(String str) {
            this.sb.appendln(str);
            return this;
        }

        @Override
        public BotLogEntryBuilder append(String format, Object ... objs) {
            this.sb.append(format, objs);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendln(String format, Object ... objs) {
            this.sb.appendln(format, objs);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendln(boolean value) {
            this.sb.appendln(value);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendln(char ch) {
            this.sb.appendln(ch);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendln(int value) {
            this.sb.appendln(value);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendln(long value) {
            this.sb.appendln(value);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendln(float value) {
            this.sb.appendln(value);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendln(double value) {
            this.sb.appendln(value);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendPadding(int length, char padChar) {
            this.sb.appendPadding(length, padChar);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendFixedWidthPadLeft(Object obj, int width, char padChar) {
            this.sb.appendFixedWidthPadLeft(obj, width, padChar);
            return this;
        }

        @Override
        public BotLogEntryBuilder appendFixedWidthPadRight(Object obj, int width, char padChar) {
            this.sb.appendFixedWidthPadRight(obj, width, padChar);
            return this;
        }

        @Override
        public BotLogEntryBuilder trim() {
            this.sb.trim();
            return this;
        }

        @Override
        public BotLogEntryBuilder withSeverity(BotLogSeverity severity) {
            this.logEntry.setSeverity(severity);
            return this;
        }

        @Override
        public BotLogEntryBuilder withException(Throwable exception) {
            this.logEntry.setException(exception);
            return this;
        }

        @Override
        public void push() {
            this.logEntry.buildMessage(this.sb.toString());
            this.logger.log(this.logEntry);
        }
    }
}

