/*
 * Decompiled with CFR 0.152.
 */
package org.msbotframework4j.connector;

import org.msbotframework4j.connector.BotConnectorClient;

abstract class AbstractBotConnectorClient
implements BotConnectorClient {
    private final String apiVersion;
    final String appId;
    final String appSecret;

    AbstractBotConnectorClient(String apiVersion, String appId, String appSecret) {
        this.apiVersion = apiVersion;
        this.appId = appId;
        this.appSecret = appSecret;
    }

    String getUserDataApi() {
        return "https://api.botframework.com" + this.getUserDataApiPath();
    }

    private String getUserDataApiPath() {
        return this.getBotApiPathPrefix() + "/users/{userId}";
    }

    String getConversationDataApi() {
        return "https://api.botframework.com" + this.getConversationDataApiPath();
    }

    private String getConversationDataApiPath() {
        return this.getBotApiPathPrefix() + "/conversations/{conversationId}";
    }

    String getPerUserConversationDataApi() {
        return "https://api.botframework.com" + this.getPerUserConversationDataApiPath();
    }

    private String getPerUserConversationDataApiPath() {
        return this.getConversationDataApiPath() + "/users/{userId}";
    }

    private String getBotApiPathPrefix() {
        return this.getApiPathPrefix() + "/bots/{botId}";
    }

    String getMessagesApi() {
        return "https://api.botframework.com" + this.getMessagesApiPath();
    }

    private String getMessagesApiPath() {
        return this.getApiPathPrefix() + "/messages";
    }

    private String getApiPathPrefix() {
        return "/bot/" + this.apiVersion;
    }
}

