/*
 * Decompiled with CFR 0.152.
 */
package org.msbotframework4j.connector;

import com.google.common.base.Optional;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.GetRequest;
import com.mashape.unirest.request.HttpRequestWithBody;
import org.apache.http.entity.ContentType;
import org.msbotframework4j.connector.AbstractBotConnectorClient;
import org.msbotframework4j.connector.BotConnectorApiException;
import org.msbotframework4j.connector.BotConnectorClient;
import org.msbotframework4j.core.model.BotData;
import org.msbotframework4j.core.model.Error;
import org.msbotframework4j.core.model.GenericApiEntity;
import org.msbotframework4j.core.model.Message;
import org.msbotframework4j.logging.BotLogSeverity;
import org.msbotframework4j.logging.BotLogger;

class BotConnectorClientAsync
extends AbstractBotConnectorClient
implements BotConnectorClient {
    private final BotLogger logger;

    BotConnectorClientAsync(BotLogger logger, String apiVersion, String appId, String appSecret) {
        super(apiVersion, appId, appSecret);
        this.logger = logger;
    }

    @Override
    public Optional<BotData> getUserData(String botId, String userId) {
        try {
            this.logger.composeLogMessage().append("Attempt to get BotData record for the user").appendWhitespaceSeparator().append("botId=%s", new Object[]{botId}).appendWhitespaceSeparator().append("userId=%s", new Object[]{userId}).withSeverity(BotLogSeverity.DEBUG).push();
            HttpResponse response = this.get(this.getUserDataApi()).routeParam("botId", botId).routeParam("userId", userId).asObject(BotData.class);
            this.validateResponseStatus((HttpResponse<? extends GenericApiEntity>)response);
            return Optional.of((Object)response.getBody());
        }
        catch (Exception ex) {
            this.logger.error("Couldn't get BotData record for the user", (Throwable)ex);
            return Optional.absent();
        }
    }

    @Override
    public Optional<BotData> setUserData(String botId, String userId, BotData data) {
        try {
            this.logger.composeLogMessage().append("Attempt to update the bot user data").appendWhitespaceSeparator().append("botId=%s", new Object[]{botId}).appendWhitespaceSeparator().append("userId=%s", new Object[]{userId}).appendWhitespaceSeparator().append("BotData=%s", new Object[]{data.toString()}).withSeverity(BotLogSeverity.DEBUG).push();
            HttpResponse response = this.post(this.getUserDataApi()).routeParam("botId", botId).routeParam("userId", userId).body((Object)data).asObject(BotData.class);
            this.validateResponseStatus((HttpResponse<? extends GenericApiEntity>)response);
            return Optional.of((Object)response.getBody());
        }
        catch (Exception ex) {
            this.logger.error("Couldn't update the bot user data", (Throwable)ex);
            return Optional.absent();
        }
    }

    @Override
    public Optional<BotData> getConversationData(String botId, String conversationId) {
        try {
            this.logger.composeLogMessage().append("Attempt to get the BotData record for the conversation").appendWhitespaceSeparator().append("botId=%s", new Object[]{botId}).appendWhitespaceSeparator().append("conversationId=%s", new Object[]{conversationId}).withSeverity(BotLogSeverity.DEBUG).push();
            HttpResponse response = this.get(this.getConversationDataApi()).routeParam("botId", botId).routeParam("conversationId", conversationId).asObject(BotData.class);
            this.validateResponseStatus((HttpResponse<? extends GenericApiEntity>)response);
            return Optional.of((Object)response.getBody());
        }
        catch (Exception ex) {
            this.logger.error("Couldn't get the BotData record for the conversation", (Throwable)ex);
            return Optional.absent();
        }
    }

    @Override
    public Optional<BotData> setConversationData(String botId, String conversationId, BotData data) {
        try {
            this.logger.composeLogMessage().append("Attempt to update the bot conversation data").appendWhitespaceSeparator().append("botId=%s", new Object[]{botId}).appendWhitespaceSeparator().append("conversationId=%s", new Object[]{conversationId}).appendWhitespaceSeparator().append("BotData=%s", new Object[]{data.toString()}).withSeverity(BotLogSeverity.DEBUG).push();
            HttpResponse response = this.post(this.getConversationDataApi()).routeParam("botId", botId).routeParam("conversationId", conversationId).body((Object)data).asObject(BotData.class);
            this.validateResponseStatus((HttpResponse<? extends GenericApiEntity>)response);
            return Optional.of((Object)response.getBody());
        }
        catch (Exception ex) {
            this.logger.error("Couldn't update the bot conversation data", (Throwable)ex);
            return Optional.absent();
        }
    }

    @Override
    public Optional<BotData> getPerUserConversationData(String botId, String conversationId, String userId) {
        try {
            this.logger.composeLogMessage().append("Attempt to get the BotData record for the user in the conversation").appendWhitespaceSeparator().append("botId=%s", new Object[]{botId}).appendWhitespaceSeparator().append("conversationId=%s", new Object[]{conversationId}).appendWhitespaceSeparator().append("userId=%s", new Object[]{userId}).withSeverity(BotLogSeverity.DEBUG).push();
            HttpResponse response = this.get(this.getPerUserConversationDataApi()).routeParam("botId", botId).routeParam("conversationId", conversationId).routeParam("userId", userId).asObject(BotData.class);
            this.validateResponseStatus((HttpResponse<? extends GenericApiEntity>)response);
            return Optional.of((Object)response.getBody());
        }
        catch (Exception ex) {
            this.logger.error("Couldn't get the BotData record for the user in the conversation", (Throwable)ex);
            return Optional.absent();
        }
    }

    @Override
    public Optional<BotData> setPerUserConversationData(String botId, String conversationId, String userId, BotData data) {
        try {
            this.logger.composeLogMessage().append("Attempt to update the bot user in a conversation data").appendWhitespaceSeparator().append("botId=%s", new Object[]{botId}).appendWhitespaceSeparator().append("conversationId=%s", new Object[]{conversationId}).appendWhitespaceSeparator().append("userId=%s", new Object[]{userId}).appendWhitespaceSeparator().append("BotData=%s", new Object[]{data.toString()}).withSeverity(BotLogSeverity.DEBUG).push();
            HttpResponse response = this.post(this.getPerUserConversationDataApi()).routeParam("botId", botId).routeParam("conversationId", conversationId).routeParam("userId", userId).body((Object)data).asObject(BotData.class);
            this.validateResponseStatus((HttpResponse<? extends GenericApiEntity>)response);
            return Optional.of((Object)response.getBody());
        }
        catch (Exception ex) {
            this.logger.error("Couldn't update the bot user in a conversation data", (Throwable)ex);
            return Optional.absent();
        }
    }

    @Override
    public Optional<Message> sendMessage(Message message) {
        try {
            this.logger.debug("Attempt to send message: " + message.toString());
            HttpResponse response = this.post(this.getMessagesApi()).body((Object)message).asObject(Message.class);
            this.validateResponseStatus((HttpResponse<? extends GenericApiEntity>)response);
            return Optional.of((Object)response.getBody());
        }
        catch (Exception ex) {
            this.logger.error("Couldn't communicate with BotConnector", (Throwable)ex);
            return Optional.absent();
        }
    }

    private HttpRequestWithBody post(String endpointUrl) {
        return Unirest.post((String)endpointUrl).basicAuth(this.appId, this.appSecret).header("Ocp-Apim-Subscription-Key", this.appSecret).header("Accept", ContentType.APPLICATION_JSON.getMimeType()).header("Content-Type", ContentType.APPLICATION_JSON.getMimeType());
    }

    private GetRequest get(String endpointUrl) {
        return Unirest.get((String)endpointUrl).basicAuth(this.appId, this.appSecret).header("Ocp-Apim-Subscription-Key", this.appSecret);
    }

    private void validateResponseStatus(HttpResponse<? extends GenericApiEntity> response) {
        GenericApiEntity entity = (GenericApiEntity)response.getBody();
        int responseHttpStatus = response.getStatus();
        Error error = entity.getError();
        if (200 == responseHttpStatus) {
            return;
        }
        this.logger.error(error.toString());
        switch (responseHttpStatus) {
            case 400: 
            case 404: 
            case 500: {
                throw new BotConnectorApiException(error.getMessage());
            }
            case 401: {
                throw new BotConnectorApiException("Authentication failed. Check HTTP request headers.");
            }
            case 403: {
                throw new BotConnectorApiException("You are forbidden from performing this action. Possible reasons: your credentials don't allow you to or your account has exceeded a quota");
            }
            case 503: {
                throw new BotConnectorApiException("The service you are trying to communicate with was unavailable");
            }
        }
        throw new IllegalArgumentException("Unknown API HTTP response status: " + responseHttpStatus + " Error: " + error.toString());
    }
}

