/*
 * Decompiled with CFR 0.152.
 */
package org.msbotframework4j.builder.wrapper;

import java.io.InputStream;
import org.apache.http.entity.ContentType;
import org.msbotframework4j.builder.wrapper.AbstractBotWrapper;
import org.msbotframework4j.core.model.Message;
import org.msbotframework4j.logging.BotLogger;
import org.msbotframework4j.logging.impl.Slf4jBotLogger;
import org.slf4j.LoggerFactory;
import spark.Request;
import spark.Response;
import spark.Route;
import spark.Spark;

public class StandaloneBotWrapper
extends AbstractBotWrapper
implements Route {
    private final Object startupShutdownMonitor = new Object();
    private Thread shutdownHook;
    private int port = 13001;

    public Object handle(Request request, Response response) throws Exception {
        Slf4jBotLogger botLogger = new Slf4jBotLogger(LoggerFactory.getLogger(StandaloneBotWrapper.class));
        Message message = this.readMessage((InputStream)request.raw().getInputStream());
        Message replyMessage = this.getReply(message, (BotLogger)botLogger);
        response.status(200);
        response.type(ContentType.APPLICATION_JSON.getMimeType());
        return this.writeMessageAsString(replyMessage);
    }

    public StandaloneBotWrapper withPort(int port) {
        this.port = port;
        return this;
    }

    public final void start() {
        this.registerShutdownHook();
        this.init();
    }

    private void init() {
        Spark.port((int)this.port);
        Spark.post((String)"/api/messages", (String)ContentType.APPLICATION_JSON.getMimeType(), (Route)this);
    }

    public final void stop() {
        Spark.stop();
    }

    private void registerShutdownHook() {
        if (this.shutdownHook == null) {
            this.shutdownHook = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = StandaloneBotWrapper.this.startupShutdownMonitor;
                    synchronized (object) {
                        Spark.stop();
                    }
                }
            };
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }
}

