/*
 * Decompiled with CFR 0.152.
 */
package org.msbotframework4j.builder.bot;

import org.msbotframework4j.builder.bot.Bot;
import org.msbotframework4j.core.model.Message;
import org.msbotframework4j.logging.BotLogger;

public abstract class AbstractBot
implements Bot {
    @Override
    public final Message getReply(Message message, BotLogger logger) {
        this.beforeProcess(message, logger);
        Message replyMessage = this.processMessageByMessageType(message, logger);
        this.beforeSend(replyMessage, message, logger);
        return replyMessage;
    }

    protected void beforeProcess(Message request, BotLogger logger) {
    }

    private Message processMessageByMessageType(Message request, BotLogger logger) {
        switch (request.getType()) {
            case MESSAGE: {
                return this.onMessage(request, logger);
            }
            case PING: {
                return this.onPing(request, logger);
            }
            case DELETE_USER_DATA: {
                return this.onDeleteUserData(request, logger);
            }
            case BOT_ADDED_TO_CONVERSATION: {
                return this.onBotAddedToConversation(request, logger);
            }
            case BOT_REMOVED_FROM_CONVERSATION: {
                return this.onBotRemovedFromConversation(request, logger);
            }
            case USER_ADDED_TO_CONVERSATION: {
                return this.onUserAddedConversation(request, logger);
            }
            case USER_REMOVED_FROM_CONVERSATION: {
                return this.onUserRemovedFromConversation(request, logger);
            }
            case END_OF_CONVERSATION: {
                return this.onEndOfConversation(request, logger);
            }
        }
        return this.defaultResponse(request, logger);
    }

    protected abstract Message onMessage(Message var1, BotLogger var2);

    protected Message onPing(Message request, BotLogger logger) {
        return request.createReplyMessage("Pong");
    }

    protected Message onDeleteUserData(Message request, BotLogger logger) {
        return this.defaultResponse(request, logger);
    }

    protected Message onBotAddedToConversation(Message request, BotLogger logger) {
        return request.createReplyMessage("Hello!");
    }

    protected Message onBotRemovedFromConversation(Message request, BotLogger logger) {
        return this.defaultResponse(request, logger);
    }

    protected Message onUserAddedConversation(Message request, BotLogger logger) {
        return this.defaultResponse(request, logger);
    }

    protected Message onUserRemovedFromConversation(Message request, BotLogger logger) {
        return this.defaultResponse(request, logger);
    }

    protected Message onEndOfConversation(Message request, BotLogger logger) {
        return request.createReplyMessage("Bye guys!");
    }

    private Message defaultResponse(Message request, BotLogger logger) {
        logger.warn("Message type is not supported: " + request.getType());
        return request.createReplyMessage("This message type is not supported yet. Please contact the bot creator.");
    }

    protected void beforeSend(Message response, Message request, BotLogger logger) {
    }
}

