/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.awsprovisioner;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.Credentials;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskClusterRequestHandler;
import org.mozilla.taskcluster.client.awsprovisioner.BackendStatusResponse;
import org.mozilla.taskcluster.client.awsprovisioner.CreateAMISetRequest;
import org.mozilla.taskcluster.client.awsprovisioner.CreateWorkerTypeRequest;
import org.mozilla.taskcluster.client.awsprovisioner.GetAMISetResponse;
import org.mozilla.taskcluster.client.awsprovisioner.GetSecretRequest;
import org.mozilla.taskcluster.client.awsprovisioner.GetSecretResponse;
import org.mozilla.taskcluster.client.awsprovisioner.GetWorkerTypeResponse;
import org.mozilla.taskcluster.client.awsprovisioner.GetWorkerTypeResponse1;
import org.mozilla.taskcluster.client.awsprovisioner.WorkerTypeSummary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwsProvisioner
extends TaskClusterRequestHandler {
    protected static final String defaultBaseURL = "https://aws-provisioner.taskcluster.net/v1";

    public AwsProvisioner(Credentials credentials) {
        super(credentials, defaultBaseURL);
    }

    public AwsProvisioner(Credentials credentials, String baseURL) {
        super(credentials, baseURL);
    }

    public AwsProvisioner(String clientId, String accessToken) {
        super(new Credentials(clientId, accessToken), defaultBaseURL);
    }

    public AwsProvisioner(String clientId, String accessToken, String certificate) {
        super(new Credentials(clientId, accessToken, certificate), defaultBaseURL);
    }

    public AwsProvisioner(String baseURL) {
        super(baseURL);
    }

    public AwsProvisioner() {
        super(defaultBaseURL);
    }

    public CallSummary<EmptyPayload, WorkerTypeSummary[]> listWorkerTypeSummaries() throws APICallFailure {
        return this.apiCall(null, "GET", "/list-worker-type-summaries", (Type)((Object)WorkerTypeSummary[].class));
    }

    public CallSummary<CreateWorkerTypeRequest, GetWorkerTypeResponse> createWorkerType(String workerType, CreateWorkerTypeRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/worker-type/" + AwsProvisioner.uriEncode(workerType), (Type)((Object)GetWorkerTypeResponse.class));
    }

    public CallSummary<CreateWorkerTypeRequest, GetWorkerTypeResponse> updateWorkerType(String workerType, CreateWorkerTypeRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/worker-type/" + AwsProvisioner.uriEncode(workerType) + "/update", (Type)((Object)GetWorkerTypeResponse.class));
    }

    public CallSummary<EmptyPayload, GetWorkerTypeResponse1> workerTypeLastModified(String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/worker-type-last-modified/" + AwsProvisioner.uriEncode(workerType), (Type)((Object)GetWorkerTypeResponse1.class));
    }

    public CallSummary<EmptyPayload, GetWorkerTypeResponse> workerType(String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/worker-type/" + AwsProvisioner.uriEncode(workerType), (Type)((Object)GetWorkerTypeResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> removeWorkerType(String workerType) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/worker-type/" + AwsProvisioner.uriEncode(workerType), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, String[]> listWorkerTypes() throws APICallFailure {
        return this.apiCall(null, "GET", "/list-worker-types", (Type)((Object)String[].class));
    }

    public CallSummary<CreateAMISetRequest, EmptyPayload> createAmiSet(String id, CreateAMISetRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/ami-set/" + AwsProvisioner.uriEncode(id), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, GetAMISetResponse> amiSet(String id) throws APICallFailure {
        return this.apiCall(null, "GET", "/ami-set/" + AwsProvisioner.uriEncode(id), (Type)((Object)GetAMISetResponse.class));
    }

    public CallSummary<CreateAMISetRequest, GetAMISetResponse> updateAmiSet(String id, CreateAMISetRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/ami-set/" + AwsProvisioner.uriEncode(id) + "/update", (Type)((Object)GetAMISetResponse.class));
    }

    public CallSummary<EmptyPayload, String[]> listAmiSets() throws APICallFailure {
        return this.apiCall(null, "GET", "/list-ami-sets", (Type)((Object)String[].class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> removeAmiSet(String id) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/ami-set/" + AwsProvisioner.uriEncode(id), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<GetSecretRequest, EmptyPayload> createSecret(String token, GetSecretRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/secret/" + AwsProvisioner.uriEncode(token), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, GetSecretResponse> getSecret(String token) throws APICallFailure {
        return this.apiCall(null, "GET", "/secret/" + AwsProvisioner.uriEncode(token), (Type)((Object)GetSecretResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> instanceStarted(String instanceId, String token) throws APICallFailure {
        return this.apiCall(null, "GET", "/instance-started/" + AwsProvisioner.uriEncode(instanceId) + "/" + AwsProvisioner.uriEncode(token), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> removeSecret(String token) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/secret/" + AwsProvisioner.uriEncode(token), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, Object> getLaunchSpecs(String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/worker-type/" + AwsProvisioner.uriEncode(workerType) + "/launch-specifications", (Type)((Object)Object.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> state(String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/state/" + AwsProvisioner.uriEncode(workerType), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, BackendStatusResponse> backendStatus() throws APICallFailure {
        return this.apiCall(null, "GET", "/backend-status", (Type)((Object)BackendStatusResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> terminateAllInstancesOfWorkerType(String workerType) throws APICallFailure {
        return this.apiCall(null, "POST", "/worker-type/" + AwsProvisioner.uriEncode(workerType) + "/terminate-all-instances", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> shutdownEverySingleEc2InstanceManagedByThisProvisioner() throws APICallFailure {
        return this.apiCall(null, "POST", "/shutdown/every/single/ec2/instance/managed/by/this/provisioner", (Type)((Object)EmptyPayload.class));
    }
}

