/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client;

import com.google.gson.Gson;
import com.wealdtech.hawk.HawkClient;
import com.wealdtech.hawk.HawkCredentials;
import java.net.URI;
import java.util.Date;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.iharder.Base64;
import org.mozilla.taskcluster.client.Certificate;
import org.mozilla.taskcluster.client.ExtAuthField;
import org.mozilla.taskcluster.client.InvalidOptionsException;

public class Credentials {
    private static final transient String algo = "HmacSHA256";
    public String[] authorizedScopes = null;
    public String accessToken = "";
    public String clientId = null;
    public String certificate = null;
    private transient HawkClient hawkClient;

    public void configureHawk() {
        HawkCredentials hawkCredentials = new HawkCredentials.Builder().keyId(this.clientId).key(this.accessToken).algorithm(HawkCredentials.Algorithm.SHA256).build();
        this.hawkClient = new HawkClient.Builder().credentials(hawkCredentials).build();
    }

    private Credentials() {
    }

    public Credentials(String clientId, String accessToken) {
        this.clientId = clientId;
        this.accessToken = accessToken;
        this.certificate = null;
        this.configureHawk();
    }

    public Credentials(String clientId, String accessToken, String certificate) {
        this.clientId = clientId;
        this.accessToken = accessToken;
        this.certificate = certificate;
        this.configureHawk();
    }

    public Credentials createTemporaryCredentials(String[] scopes, Date start, Date expiry) throws InvalidOptionsException {
        return this.createTemporaryCredentials("", scopes, start, expiry);
    }

    public Credentials createTemporaryCredentials(String clientId, String[] scopes, Date start, Date expiry) throws InvalidOptionsException {
        if (start.after(expiry)) {
            throw new InvalidOptionsException(new Throwable("start should be before expiry"));
        }
        if (expiry.getTime() - start.getTime() > 2678400000L) {
            throw new InvalidOptionsException(new Throwable("Cannot exceed 31 days"));
        }
        Certificate cert = new Certificate(1, start, expiry, scopes);
        if (clientId != null && !clientId.equals("")) {
            cert.issuer = this.clientId;
        }
        cert.generateSignature(this.accessToken, clientId);
        String temporaryAccessToken = Credentials.generateTemporaryAccessToken(this.accessToken, cert.seed);
        if (clientId != null && !clientId.equals("")) {
            return new Credentials(clientId, temporaryAccessToken, cert.toString());
        }
        return new Credentials(this.clientId, temporaryAccessToken, cert.toString());
    }

    public static String generateTemporaryAccessToken(String accessToken, String seed) {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(accessToken.getBytes("utf-8"), algo);
            Mac mac = Mac.getInstance(algo);
            mac.init(keySpec);
            return Base64.encodeBytes((byte[])mac.doFinal(seed.getBytes("utf-8"))).replace('+', '-').replace('/', '_').replace("=", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String GetExtAuthField() {
        Gson gson = new Gson();
        ExtAuthField extAuthField = new ExtAuthField(this.getCertificate(), this.authorizedScopes);
        String ext = gson.toJson((Object)extAuthField);
        if (ext.equals("{}")) {
            return "";
        }
        return Base64.encodeBytes((byte[])ext.getBytes());
    }

    public String generateAuthorizationHeader(URI uri, String method, String hash) {
        return this.hawkClient.generateAuthorizationHeader(uri, method, hash, this.GetExtAuthField(), null, null);
    }

    public Certificate getCertificate() {
        Gson gson = new Gson();
        return (Certificate)gson.fromJson(this.certificate, Certificate.class);
    }

    public String toString() {
        Gson gson = new Gson();
        return gson.toJson((Object)this);
    }
}

