/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import net.iharder.Base64;
import org.mozilla.taskcluster.client.InvalidOptionsException;

public class Certificate {
    public int version = 1;
    public String[] scopes;
    public long start;
    public long expiry;
    public String seed;
    public String signature = null;
    private final transient String algo = "HmacSHA256";
    public String issuer = null;

    public Certificate(int version, Date start, Date expiry, String[] scopes) {
        this.version = version;
        this.start = start.getTime();
        this.expiry = expiry.getTime();
        this.scopes = scopes;
        this.signature = null;
        this.generateSeed();
    }

    private void generateSeed() {
        this.seed = Certificate.slug() + Certificate.slug();
    }

    private static String slug() {
        UUID uuid = UUID.randomUUID();
        long hi = uuid.getMostSignificantBits();
        long lo = uuid.getLeastSignificantBits();
        ByteBuffer raw = ByteBuffer.allocate(16);
        raw.putLong(hi);
        raw.putLong(lo);
        byte[] rawBytes = raw.array();
        return Base64.encodeBytes((byte[])rawBytes).replace('+', '-').replace('/', '_').substring(0, 22);
    }

    public void generateSignature(String accessToken, String tempClientId) throws InvalidOptionsException {
        try {
            SecretKeySpec keySpec = new SecretKeySpec(accessToken.getBytes("utf-8"), "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(keySpec);
            StringBuilder builder = new StringBuilder();
            builder.append("version:" + Integer.toString(this.version) + "\n");
            if (tempClientId != null && this.issuer != null && !tempClientId.equals("") && !this.issuer.equals("")) {
                builder.append("clientId:" + tempClientId + "\n");
                builder.append("issuer:" + this.issuer + "\n");
            }
            builder.append("seed:" + this.seed + "\n");
            builder.append("start:" + Long.toString(this.start) + "\n");
            builder.append("expiry:" + Long.toString(this.expiry) + "\n");
            builder.append("scopes:");
            for (String scope : this.scopes) {
                builder.append("\n" + scope);
            }
            String temp = builder.toString();
            this.signature = Base64.encodeBytes((byte[])mac.doFinal(temp.getBytes("utf-8")));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new InvalidOptionsException(e);
        }
    }

    public String toString() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        return gson.toJson((Object)this);
    }
}

