/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.scheduler;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskClusterRequestHandler;
import org.mozilla.taskcluster.client.scheduler.InspectTaskGraphResponse;
import org.mozilla.taskcluster.client.scheduler.InspectTaskGraphTaskResponse;
import org.mozilla.taskcluster.client.scheduler.TaskGraphDefinition;
import org.mozilla.taskcluster.client.scheduler.TaskGraphDefinition1;
import org.mozilla.taskcluster.client.scheduler.TaskGraphInfoResponse;
import org.mozilla.taskcluster.client.scheduler.TaskGraphStatusResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scheduler
extends TaskClusterRequestHandler {
    protected static final String defaultBaseURL = "https://scheduler.taskcluster.net/v1";

    public Scheduler(String clientId, String accessToken) {
        super(clientId, accessToken, defaultBaseURL);
    }

    public Scheduler(String clientId, String accessToken, String certificate) {
        super(clientId, accessToken, certificate, defaultBaseURL);
    }

    public Scheduler(String baseURL) {
        super(baseURL);
    }

    public Scheduler() {
        super(defaultBaseURL);
    }

    public CallSummary<TaskGraphDefinition1, TaskGraphStatusResponse> createTaskGraph(String taskGraphId, TaskGraphDefinition1 payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/task-graph/" + Scheduler.uriEncode(taskGraphId), (Type)((Object)TaskGraphStatusResponse.class));
    }

    public CallSummary<TaskGraphDefinition, TaskGraphStatusResponse> extendTaskGraph(String taskGraphId, TaskGraphDefinition payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/task-graph/" + Scheduler.uriEncode(taskGraphId) + "/extend", (Type)((Object)TaskGraphStatusResponse.class));
    }

    public CallSummary<EmptyPayload, TaskGraphStatusResponse> status(String taskGraphId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task-graph/" + Scheduler.uriEncode(taskGraphId) + "/status", (Type)((Object)TaskGraphStatusResponse.class));
    }

    public CallSummary<EmptyPayload, TaskGraphInfoResponse> info(String taskGraphId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task-graph/" + Scheduler.uriEncode(taskGraphId) + "/info", (Type)((Object)TaskGraphInfoResponse.class));
    }

    public CallSummary<EmptyPayload, InspectTaskGraphResponse> inspect(String taskGraphId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task-graph/" + Scheduler.uriEncode(taskGraphId) + "/inspect", (Type)((Object)InspectTaskGraphResponse.class));
    }

    public CallSummary<EmptyPayload, InspectTaskGraphTaskResponse> inspectTask(String taskGraphId, String taskId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task-graph/" + Scheduler.uriEncode(taskGraphId) + "/inspect/" + Scheduler.uriEncode(taskId), (Type)((Object)InspectTaskGraphTaskResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }
}

