/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.auth;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskClusterRequestHandler;
import org.mozilla.taskcluster.client.auth.AWSS3CredentialsResponse;
import org.mozilla.taskcluster.client.auth.AzureSharedAccessSignatureResponse;
import org.mozilla.taskcluster.client.auth.CreateClientRequest;
import org.mozilla.taskcluster.client.auth.CreateClientResponse;
import org.mozilla.taskcluster.client.auth.CreateRoleRequest;
import org.mozilla.taskcluster.client.auth.ExportedClients;
import org.mozilla.taskcluster.client.auth.GetClientResponse;
import org.mozilla.taskcluster.client.auth.GetRoleResponse;
import org.mozilla.taskcluster.client.auth.HawkSignatureAuthenticationRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Auth
extends TaskClusterRequestHandler {
    protected static final String defaultBaseURL = "https://auth.taskcluster.net/v1";

    public Auth(String clientId, String accessToken) {
        super(clientId, accessToken, defaultBaseURL);
    }

    public Auth(String clientId, String accessToken, String certificate) {
        super(clientId, accessToken, certificate, defaultBaseURL);
    }

    public Auth(String baseURL) {
        super(baseURL);
    }

    public Auth() {
        super(defaultBaseURL);
    }

    public CallSummary<EmptyPayload, GetClientResponse[]> listClients() throws APICallFailure {
        return this.apiCall(null, "GET", "/clients/", (Type)((Object)GetClientResponse[].class));
    }

    public CallSummary<EmptyPayload, GetClientResponse> client(String clientId) throws APICallFailure {
        return this.apiCall(null, "GET", "/clients/" + Auth.uriEncode(clientId), (Type)((Object)GetClientResponse.class));
    }

    public CallSummary<CreateClientRequest, CreateClientResponse> createClient(String clientId, CreateClientRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/clients/" + Auth.uriEncode(clientId), (Type)((Object)CreateClientResponse.class));
    }

    public CallSummary<EmptyPayload, CreateClientResponse> resetAccessToken(String clientId) throws APICallFailure {
        return this.apiCall(null, "POST", "/clients/" + Auth.uriEncode(clientId) + "/reset", (Type)((Object)CreateClientResponse.class));
    }

    public CallSummary<CreateClientRequest, GetClientResponse> updateClient(String clientId, CreateClientRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/clients/" + Auth.uriEncode(clientId), (Type)((Object)GetClientResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> deleteClient(String clientId) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/clients/" + Auth.uriEncode(clientId), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, GetRoleResponse[]> listRoles() throws APICallFailure {
        return this.apiCall(null, "GET", "/roles/", (Type)((Object)GetRoleResponse[].class));
    }

    public CallSummary<EmptyPayload, GetRoleResponse> role(String roleId) throws APICallFailure {
        return this.apiCall(null, "GET", "/roles/" + Auth.uriEncode(roleId), (Type)((Object)GetRoleResponse.class));
    }

    public CallSummary<CreateRoleRequest, GetRoleResponse> createRole(String roleId, CreateRoleRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/roles/" + Auth.uriEncode(roleId), (Type)((Object)GetRoleResponse.class));
    }

    public CallSummary<CreateRoleRequest, GetRoleResponse> updateRole(String roleId, CreateRoleRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/roles/" + Auth.uriEncode(roleId), (Type)((Object)GetRoleResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> deleteRole(String roleId) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/roles/" + Auth.uriEncode(roleId), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, AWSS3CredentialsResponse> awsS3Credentials(String level, String bucket, String prefix) throws APICallFailure {
        return this.apiCall(null, "GET", "/aws/s3/" + Auth.uriEncode(level) + "/" + Auth.uriEncode(bucket) + "/" + Auth.uriEncode(prefix), (Type)((Object)AWSS3CredentialsResponse.class));
    }

    public CallSummary<EmptyPayload, AzureSharedAccessSignatureResponse> azureTableSAS(String account, String table) throws APICallFailure {
        return this.apiCall(null, "GET", "/azure/" + Auth.uriEncode(account) + "/table/" + Auth.uriEncode(table) + "/read-write", (Type)((Object)AzureSharedAccessSignatureResponse.class));
    }

    public CallSummary<HawkSignatureAuthenticationRequest, Object> authenticateHawk(HawkSignatureAuthenticationRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/authenticate-hawk", (Type)((Object)Object.class));
    }

    public CallSummary<ExportedClients, EmptyPayload> importClients(ExportedClients payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/import-clients", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }
}

