/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.wealdtech.hawk.HawkClient;
import com.wealdtech.hawk.HawkCredentials;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import net.iharder.Base64;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskClusterRequestHandler {
    static final Gson gson;
    static HttpRequestFactory requestFactory;
    private String accessToken;
    private boolean authenticate;
    private String baseURL;
    private String certificate;
    private String clientId;
    private HawkClient hawkClient;

    public void configureHawk() {
        HawkCredentials hawkCredentials = new HawkCredentials.Builder().keyId(this.clientId).key(this.accessToken).algorithm(HawkCredentials.Algorithm.SHA256).build();
        this.hawkClient = new HawkClient.Builder().credentials(hawkCredentials).build();
    }

    public TaskClusterRequestHandler(String clientId, String accessToken, String baseURL) {
        this.accessToken = accessToken;
        this.authenticate = true;
        this.baseURL = baseURL;
        this.certificate = null;
        this.clientId = clientId;
        this.configureHawk();
    }

    public TaskClusterRequestHandler(String clientId, String accessToken, String certificate, String baseURL) {
        this.accessToken = accessToken;
        this.authenticate = true;
        this.baseURL = baseURL;
        this.certificate = certificate;
        this.clientId = clientId;
        this.configureHawk();
    }

    public TaskClusterRequestHandler(String baseURL) {
        this.authenticate = false;
        this.baseURL = baseURL;
        this.clientId = null;
        this.accessToken = null;
        this.certificate = null;
        this.hawkClient = null;
    }

    public TaskClusterRequestHandler setBaseURL(String baseURL) {
        this.baseURL = baseURL;
        return this;
    }

    protected <Request, Response> CallSummary<Request, Response> apiCall(Request payload, String method, String route, Type responseType) throws APICallFailure {
        CallSummary callSummary = new CallSummary();
        callSummary.requestPayload = payload;
        callSummary.requestBody = payload != null ? gson.toJson(payload) : "";
        ByteArrayContent httpRequestContent = new ByteArrayContent("application/json", callSummary.requestBody.getBytes());
        try {
            HttpRequest request = requestFactory.buildRequest(method, new GenericUrl(this.baseURL + route), (HttpContent)httpRequestContent);
            if (this.authenticate) {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                messageDigest.update(callSummary.requestBody.getBytes());
                String hash = null;
                String ext = null;
                if (this.certificate != null) {
                    ext = Base64.encodeBytes((byte[])("{\"certificate\":" + this.certificate + "}").getBytes());
                }
                URI uri = new URI(this.baseURL + route);
                String authorizationHeader = this.hawkClient.generateAuthorizationHeader(uri, method, hash, ext, null, null);
                HttpHeaders headers = new HttpHeaders();
                headers.setAuthorization(authorizationHeader);
                request.setHeaders(headers);
            }
            request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff()));
            HttpResponse httpResponse = request.execute();
            callSummary.responseBody = httpResponse.parseAsString();
            callSummary.responsePayload = callSummary.responseBody != "" ? gson.fromJson(callSummary.responseBody, responseType) : null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new APICallFailure(e);
        }
        return callSummary;
    }

    protected static String uriEncode(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(64);
            return null;
        }
    }

    static {
        final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        JsonSerializer<Date> ser = new JsonSerializer<Date>(){

            public JsonElement serialize(Date date, Type typeOfSrc, JsonSerializationContext context) {
                return date == null ? null : new JsonPrimitive(sdf.format(date));
            }
        };
        JsonDeserializer<Date> deser = new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return json == null ? null : sdf.parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new JsonParseException((Throwable)e);
                }
            }
        };
        gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)ser).registerTypeAdapter(Date.class, (Object)deser).create();
        NetHttpTransport httpTransport = new NetHttpTransport();
        requestFactory = httpTransport.createRequestFactory();
    }
}

