/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.login;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.Credentials;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskclusterRequestHandler;
import org.mozilla.taskcluster.client.login.CredentialsResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Login
extends TaskclusterRequestHandler {
    protected static final String defaultBaseURL = "https://login.taskcluster.net/v1";

    public Login(Credentials credentials) {
        super(credentials, defaultBaseURL);
    }

    public Login(Credentials credentials, String baseURL) {
        super(credentials, baseURL);
    }

    public Login(String clientId, String accessToken) {
        super(new Credentials(clientId, accessToken), defaultBaseURL);
    }

    public Login(String clientId, String accessToken, String certificate) {
        super(new Credentials(clientId, accessToken, certificate), defaultBaseURL);
    }

    public Login(String baseURL) {
        super(baseURL);
    }

    public Login() {
        super(defaultBaseURL);
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, CredentialsResponse> oidcCredentials(String provider) throws APICallFailure {
        return this.apiCall(null, "GET", "/oidc-credentials/" + Login.uriEncode(provider), (Type)((Object)CredentialsResponse.class));
    }
}

