/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.auth;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.Credentials;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskclusterRequestHandler;
import org.mozilla.taskcluster.client.auth.AWSS3CredentialsResponse;
import org.mozilla.taskcluster.client.auth.AzureBlobSharedAccessSignature;
import org.mozilla.taskcluster.client.auth.AzureListAccountResponse;
import org.mozilla.taskcluster.client.auth.AzureListContainersResponse;
import org.mozilla.taskcluster.client.auth.AzureListTableResponse;
import org.mozilla.taskcluster.client.auth.AzureTableSharedAccessSignature;
import org.mozilla.taskcluster.client.auth.CreateClientRequest;
import org.mozilla.taskcluster.client.auth.CreateClientResponse;
import org.mozilla.taskcluster.client.auth.CreateRoleRequest;
import org.mozilla.taskcluster.client.auth.GetClientResponse;
import org.mozilla.taskcluster.client.auth.GetRoleResponse;
import org.mozilla.taskcluster.client.auth.HawkSignatureAuthenticationRequest;
import org.mozilla.taskcluster.client.auth.ListClientResponse;
import org.mozilla.taskcluster.client.auth.SentryDSNResponse;
import org.mozilla.taskcluster.client.auth.SetOfScopes;
import org.mozilla.taskcluster.client.auth.StatsumTokenResponse;
import org.mozilla.taskcluster.client.auth.TestAuthenticateRequest;
import org.mozilla.taskcluster.client.auth.TestAuthenticateResponse;
import org.mozilla.taskcluster.client.auth.WebhooktunnelTokenResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Auth
extends TaskclusterRequestHandler {
    protected static final String defaultBaseURL = "https://auth.taskcluster.net/v1";

    public Auth(Credentials credentials) {
        super(credentials, defaultBaseURL);
    }

    public Auth(Credentials credentials, String baseURL) {
        super(credentials, baseURL);
    }

    public Auth(String clientId, String accessToken) {
        super(new Credentials(clientId, accessToken), defaultBaseURL);
    }

    public Auth(String clientId, String accessToken, String certificate) {
        super(new Credentials(clientId, accessToken, certificate), defaultBaseURL);
    }

    public Auth(String baseURL) {
        super(baseURL);
    }

    public Auth() {
        super(defaultBaseURL);
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, ListClientResponse> listClients() throws APICallFailure {
        return this.apiCall(null, "GET", "/clients/", (Type)((Object)ListClientResponse.class));
    }

    public CallSummary<EmptyPayload, GetClientResponse> client(String clientId) throws APICallFailure {
        return this.apiCall(null, "GET", "/clients/" + Auth.uriEncode(clientId), (Type)((Object)GetClientResponse.class));
    }

    public CallSummary<CreateClientRequest, CreateClientResponse> createClient(String clientId, CreateClientRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/clients/" + Auth.uriEncode(clientId), (Type)((Object)CreateClientResponse.class));
    }

    public CallSummary<EmptyPayload, CreateClientResponse> resetAccessToken(String clientId) throws APICallFailure {
        return this.apiCall(null, "POST", "/clients/" + Auth.uriEncode(clientId) + "/reset", (Type)((Object)CreateClientResponse.class));
    }

    public CallSummary<CreateClientRequest, GetClientResponse> updateClient(String clientId, CreateClientRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/clients/" + Auth.uriEncode(clientId), (Type)((Object)GetClientResponse.class));
    }

    public CallSummary<EmptyPayload, GetClientResponse> enableClient(String clientId) throws APICallFailure {
        return this.apiCall(null, "POST", "/clients/" + Auth.uriEncode(clientId) + "/enable", (Type)((Object)GetClientResponse.class));
    }

    public CallSummary<EmptyPayload, GetClientResponse> disableClient(String clientId) throws APICallFailure {
        return this.apiCall(null, "POST", "/clients/" + Auth.uriEncode(clientId) + "/disable", (Type)((Object)GetClientResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> deleteClient(String clientId) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/clients/" + Auth.uriEncode(clientId), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, GetRoleResponse[]> listRoles() throws APICallFailure {
        return this.apiCall(null, "GET", "/roles/", (Type)((Object)GetRoleResponse[].class));
    }

    public CallSummary<EmptyPayload, GetRoleResponse> role(String roleId) throws APICallFailure {
        return this.apiCall(null, "GET", "/roles/" + Auth.uriEncode(roleId), (Type)((Object)GetRoleResponse.class));
    }

    public CallSummary<CreateRoleRequest, GetRoleResponse> createRole(String roleId, CreateRoleRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/roles/" + Auth.uriEncode(roleId), (Type)((Object)GetRoleResponse.class));
    }

    public CallSummary<CreateRoleRequest, GetRoleResponse> updateRole(String roleId, CreateRoleRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/roles/" + Auth.uriEncode(roleId), (Type)((Object)GetRoleResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> deleteRole(String roleId) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/roles/" + Auth.uriEncode(roleId), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<SetOfScopes, SetOfScopes> expandScopesGet(SetOfScopes payload) throws APICallFailure {
        return this.apiCall(payload, "GET", "/scopes/expand", (Type)((Object)SetOfScopes.class));
    }

    public CallSummary<SetOfScopes, SetOfScopes> expandScopes(SetOfScopes payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/scopes/expand", (Type)((Object)SetOfScopes.class));
    }

    public CallSummary<EmptyPayload, SetOfScopes> currentScopes() throws APICallFailure {
        return this.apiCall(null, "GET", "/scopes/current", (Type)((Object)SetOfScopes.class));
    }

    public CallSummary<EmptyPayload, AWSS3CredentialsResponse> awsS3Credentials(String level, String bucket, String prefix) throws APICallFailure {
        return this.apiCall(null, "GET", "/aws/s3/" + Auth.uriEncode(level) + "/" + Auth.uriEncode(bucket) + "/" + Auth.uriEncode(prefix), (Type)((Object)AWSS3CredentialsResponse.class));
    }

    public CallSummary<EmptyPayload, AzureListAccountResponse> azureAccounts() throws APICallFailure {
        return this.apiCall(null, "GET", "/azure/accounts", (Type)((Object)AzureListAccountResponse.class));
    }

    public CallSummary<EmptyPayload, AzureListTableResponse> azureTables(String account) throws APICallFailure {
        return this.apiCall(null, "GET", "/azure/" + Auth.uriEncode(account) + "/tables", (Type)((Object)AzureListTableResponse.class));
    }

    public CallSummary<EmptyPayload, AzureTableSharedAccessSignature> azureTableSAS(String account, String table, String level) throws APICallFailure {
        return this.apiCall(null, "GET", "/azure/" + Auth.uriEncode(account) + "/table/" + Auth.uriEncode(table) + "/" + Auth.uriEncode(level), (Type)((Object)AzureTableSharedAccessSignature.class));
    }

    public CallSummary<EmptyPayload, AzureListContainersResponse> azureContainers(String account) throws APICallFailure {
        return this.apiCall(null, "GET", "/azure/" + Auth.uriEncode(account) + "/containers", (Type)((Object)AzureListContainersResponse.class));
    }

    public CallSummary<EmptyPayload, AzureBlobSharedAccessSignature> azureContainerSAS(String account, String container, String level) throws APICallFailure {
        return this.apiCall(null, "GET", "/azure/" + Auth.uriEncode(account) + "/containers/" + Auth.uriEncode(container) + "/" + Auth.uriEncode(level), (Type)((Object)AzureBlobSharedAccessSignature.class));
    }

    public CallSummary<EmptyPayload, SentryDSNResponse> sentryDSN(String project) throws APICallFailure {
        return this.apiCall(null, "GET", "/sentry/" + Auth.uriEncode(project) + "/dsn", (Type)((Object)SentryDSNResponse.class));
    }

    public CallSummary<EmptyPayload, StatsumTokenResponse> statsumToken(String project) throws APICallFailure {
        return this.apiCall(null, "GET", "/statsum/" + Auth.uriEncode(project) + "/token", (Type)((Object)StatsumTokenResponse.class));
    }

    public CallSummary<EmptyPayload, WebhooktunnelTokenResponse> webhooktunnelToken() throws APICallFailure {
        return this.apiCall(null, "GET", "/webhooktunnel", (Type)((Object)WebhooktunnelTokenResponse.class));
    }

    public CallSummary<HawkSignatureAuthenticationRequest, Object> authenticateHawk(HawkSignatureAuthenticationRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/authenticate-hawk", (Type)((Object)Object.class));
    }

    public CallSummary<TestAuthenticateRequest, TestAuthenticateResponse> testAuthenticate(TestAuthenticateRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/test-authenticate", (Type)((Object)TestAuthenticateResponse.class));
    }

    public CallSummary<EmptyPayload, TestAuthenticateResponse> testAuthenticateGet() throws APICallFailure {
        return this.apiCall(null, "GET", "/test-authenticate-get/", (Type)((Object)TestAuthenticateResponse.class));
    }
}

