/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client;

import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpBackOffUnsuccessfulResponseHandler;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.ExponentialBackOff;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.Credentials;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaskclusterRequestHandler {
    static final Gson gson;
    static HttpRequestFactory requestFactory;
    private Credentials credentials;
    private boolean authenticate;
    private String baseURL;

    public TaskclusterRequestHandler(Credentials credentials, String baseURL) {
        this.authenticate = true;
        this.baseURL = baseURL;
        this.credentials = credentials;
    }

    public TaskclusterRequestHandler(String baseURL) {
        this.authenticate = false;
        this.baseURL = baseURL;
        this.credentials = null;
    }

    public TaskclusterRequestHandler setBaseURL(String baseURL) {
        this.baseURL = baseURL;
        return this;
    }

    protected <Request, Response> CallSummary<Request, Response> apiCall(Request payload, String method, String route, Type responseType) throws APICallFailure {
        CallSummary callSummary = new CallSummary();
        callSummary.requestPayload = payload;
        callSummary.requestBody = payload != null ? gson.toJson(payload) : "";
        ByteArrayContent httpRequestContent = new ByteArrayContent("application/json", callSummary.requestBody.getBytes());
        try {
            HttpRequest request = requestFactory.buildRequest(method, new GenericUrl(this.baseURL + route), (HttpContent)httpRequestContent);
            if (this.authenticate) {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
                messageDigest.update(callSummary.requestBody.getBytes());
                String hash = null;
                String url = this.baseURL;
                if (url.endsWith("/")) {
                    url = url.substring(0, url.length() - 1);
                }
                url = url + route;
                URI uri = new URI(url);
                if (this.credentials != null && this.authenticate) {
                    String authorizationHeader = this.credentials.generateAuthorizationHeader(uri, method, hash);
                    HttpHeaders headers = new HttpHeaders();
                    headers.setAuthorization(authorizationHeader);
                    request.setHeaders(headers);
                }
            }
            request.setUnsuccessfulResponseHandler((HttpUnsuccessfulResponseHandler)new HttpBackOffUnsuccessfulResponseHandler((BackOff)new ExponentialBackOff()));
            HttpResponse httpResponse = request.execute();
            callSummary.responseBody = httpResponse.parseAsString();
            callSummary.responsePayload = callSummary.responseBody != "" ? gson.fromJson(callSummary.responseBody, responseType) : null;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (HttpResponseException e) {
            System.out.println(e.getContent());
            throw new APICallFailure(e);
        }
        catch (IOException e) {
            throw new APICallFailure(e);
        }
        return callSummary;
    }

    protected static String uriEncode(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(64);
            return null;
        }
    }

    static {
        final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        JsonSerializer<Date> ser = new JsonSerializer<Date>(){

            public JsonElement serialize(Date date, Type typeOfSrc, JsonSerializationContext context) {
                return date == null ? null : new JsonPrimitive(sdf.format(date));
            }
        };
        JsonDeserializer<Date> deser = new JsonDeserializer<Date>(){

            public Date deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
                try {
                    return json == null ? null : sdf.parse(json.getAsJsonPrimitive().getAsString());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new JsonParseException((Throwable)e);
                }
            }
        };
        gson = new GsonBuilder().registerTypeAdapter(Date.class, (Object)ser).registerTypeAdapter(Date.class, (Object)deser).create();
        NetHttpTransport httpTransport = new NetHttpTransport();
        requestFactory = httpTransport.createRequestFactory();
        Logger.getLogger(HttpTransport.class.getName()).setLevel(Level.ALL);
    }
}

