/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.ec2manager;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.Credentials;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskclusterRequestHandler;
import org.mozilla.taskcluster.client.ec2manager.Entry1;
import org.mozilla.taskcluster.client.ec2manager.Entry3;
import org.mozilla.taskcluster.client.ec2manager.Errors;
import org.mozilla.taskcluster.client.ec2manager.HealthOfTheEC2Account;
import org.mozilla.taskcluster.client.ec2manager.MakeASpotRequest;
import org.mozilla.taskcluster.client.ec2manager.OverviewOfComputationalResources;
import org.mozilla.taskcluster.client.ec2manager.OverviewOfComputationalResources1;
import org.mozilla.taskcluster.client.ec2manager.SshPublicKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EC2Manager
extends TaskclusterRequestHandler {
    protected static final String defaultBaseURL = "localhost:5555/v1";

    public EC2Manager(Credentials credentials) {
        super(credentials, defaultBaseURL);
    }

    public EC2Manager(Credentials credentials, String baseURL) {
        super(credentials, baseURL);
    }

    public EC2Manager(String clientId, String accessToken) {
        super(new Credentials(clientId, accessToken), defaultBaseURL);
    }

    public EC2Manager(String clientId, String accessToken, String certificate) {
        super(new Credentials(clientId, accessToken, certificate), defaultBaseURL);
    }

    public EC2Manager(String baseURL) {
        super(baseURL);
    }

    public EC2Manager() {
        super(defaultBaseURL);
    }

    public CallSummary<EmptyPayload, String[]> listWorkerTypes() throws APICallFailure {
        return this.apiCall(null, "GET", "/worker-types", (Type)((Object)String[].class));
    }

    public CallSummary<MakeASpotRequest, EmptyPayload> runInstance(String workerType, MakeASpotRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/worker-types/" + EC2Manager.uriEncode(workerType) + "/instance", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> terminateWorkerType(String workerType) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/worker-types/" + EC2Manager.uriEncode(workerType) + "/resources", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, OverviewOfComputationalResources> workerTypeStats(String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/worker-types/" + EC2Manager.uriEncode(workerType) + "/stats", (Type)((Object)OverviewOfComputationalResources.class));
    }

    public CallSummary<EmptyPayload, HealthOfTheEC2Account> workerTypeHealth(String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/worker-types/" + EC2Manager.uriEncode(workerType) + "/health", (Type)((Object)HealthOfTheEC2Account.class));
    }

    public CallSummary<EmptyPayload, Errors> workerTypeErrors(String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/worker-types/" + EC2Manager.uriEncode(workerType) + "/errors", (Type)((Object)Errors.class));
    }

    public CallSummary<EmptyPayload, OverviewOfComputationalResources1> workerTypeState(String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/worker-types/" + EC2Manager.uriEncode(workerType) + "/state", (Type)((Object)OverviewOfComputationalResources1.class));
    }

    public CallSummary<SshPublicKey, EmptyPayload> ensureKeyPair(String name, SshPublicKey payload) throws APICallFailure {
        return this.apiCall(payload, "GET", "/key-pairs/" + EC2Manager.uriEncode(name), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> removeKeyPair(String name) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/key-pairs/" + EC2Manager.uriEncode(name), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> terminateInstance(String region, String instanceId) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/region/" + EC2Manager.uriEncode(region) + "/instance/" + EC2Manager.uriEncode(instanceId), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, Entry1[]> getPrices() throws APICallFailure {
        return this.apiCall(null, "GET", "/prices", (Type)((Object)Entry1[].class));
    }

    public CallSummary<Entry3[], Entry1[]> getSpecificPrices(Entry3[] payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/prices", (Type)((Object)Entry1[].class));
    }

    public CallSummary<EmptyPayload, HealthOfTheEC2Account> getHealth() throws APICallFailure {
        return this.apiCall(null, "GET", "/health", (Type)((Object)HealthOfTheEC2Account.class));
    }

    public CallSummary<EmptyPayload, Errors> getRecentErrors() throws APICallFailure {
        return this.apiCall(null, "GET", "/errors", (Type)((Object)Errors.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> regions() throws APICallFailure {
        return this.apiCall(null, "GET", "/internal/regions", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> amiUsage() throws APICallFailure {
        return this.apiCall(null, "GET", "/internal/ami-usage", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ebsUsage() throws APICallFailure {
        return this.apiCall(null, "GET", "/internal/ebs-usage", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> dbpoolStats() throws APICallFailure {
        return this.apiCall(null, "GET", "/internal/db-pool-stats", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> allState() throws APICallFailure {
        return this.apiCall(null, "GET", "/internal/all-state", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> sqsStats() throws APICallFailure {
        return this.apiCall(null, "GET", "/internal/sqs-stats", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> purgeQueues() throws APICallFailure {
        return this.apiCall(null, "GET", "/internal/purge-queues", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> apiReference() throws APICallFailure {
        return this.apiCall(null, "GET", "/internal/api-reference", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }
}

