/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.index;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.Credentials;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskclusterRequestHandler;
import org.mozilla.taskcluster.client.index.IndexedTaskResponse;
import org.mozilla.taskcluster.client.index.InsertTaskRequest;
import org.mozilla.taskcluster.client.index.ListNamespacesRequest;
import org.mozilla.taskcluster.client.index.ListNamespacesResponse;
import org.mozilla.taskcluster.client.index.ListTasksRequest;
import org.mozilla.taskcluster.client.index.ListTasksResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index
extends TaskclusterRequestHandler {
    protected static final String defaultBaseURL = "https://index.taskcluster.net/v1";

    public Index(Credentials credentials) {
        super(credentials, defaultBaseURL);
    }

    public Index(Credentials credentials, String baseURL) {
        super(credentials, baseURL);
    }

    public Index(String clientId, String accessToken) {
        super(new Credentials(clientId, accessToken), defaultBaseURL);
    }

    public Index(String clientId, String accessToken, String certificate) {
        super(new Credentials(clientId, accessToken, certificate), defaultBaseURL);
    }

    public Index(String baseURL) {
        super(baseURL);
    }

    public Index() {
        super(defaultBaseURL);
    }

    public CallSummary<EmptyPayload, IndexedTaskResponse> findTask(String indexPath) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + Index.uriEncode(indexPath), (Type)((Object)IndexedTaskResponse.class));
    }

    public CallSummary<EmptyPayload, ListNamespacesResponse> listNamespaces(String namespace) throws APICallFailure {
        return this.apiCall(null, "GET", "/namespaces/" + Index.uriEncode(namespace), (Type)((Object)ListNamespacesResponse.class));
    }

    public CallSummary<ListNamespacesRequest, ListNamespacesResponse> listNamespacesPost(String namespace, ListNamespacesRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/namespaces/" + Index.uriEncode(namespace), (Type)((Object)ListNamespacesResponse.class));
    }

    public CallSummary<ListTasksRequest, ListTasksResponse> listTasks(String namespace, ListTasksRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/tasks/" + Index.uriEncode(namespace), (Type)((Object)ListTasksResponse.class));
    }

    public CallSummary<InsertTaskRequest, IndexedTaskResponse> insertTask(String namespace, InsertTaskRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/task/" + Index.uriEncode(namespace), (Type)((Object)IndexedTaskResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> findArtifactFromTask(String indexPath, String name) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + Index.uriEncode(indexPath) + "/artifacts/" + Index.uriEncode(name), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }
}

