/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.secrets;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.Credentials;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskclusterRequestHandler;
import org.mozilla.taskcluster.client.secrets.Secret;
import org.mozilla.taskcluster.client.secrets.SecretsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Secrets
extends TaskclusterRequestHandler {
    protected static final String defaultBaseURL = "https://secrets.taskcluster.net/v1";

    public Secrets(Credentials credentials) {
        super(credentials, defaultBaseURL);
    }

    public Secrets(Credentials credentials, String baseURL) {
        super(credentials, baseURL);
    }

    public Secrets(String clientId, String accessToken) {
        super(new Credentials(clientId, accessToken), defaultBaseURL);
    }

    public Secrets(String clientId, String accessToken, String certificate) {
        super(new Credentials(clientId, accessToken, certificate), defaultBaseURL);
    }

    public Secrets(String baseURL) {
        super(baseURL);
    }

    public Secrets() {
        super(defaultBaseURL);
    }

    public CallSummary<Secret, EmptyPayload> set(String name, Secret payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/secret/" + Secrets.uriEncode(name), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> remove(String name) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/secret/" + Secrets.uriEncode(name), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, Secret> get(String name) throws APICallFailure {
        return this.apiCall(null, "GET", "/secret/" + Secrets.uriEncode(name), (Type)((Object)Secret.class));
    }

    public CallSummary<EmptyPayload, SecretsList> list() throws APICallFailure {
        return this.apiCall(null, "GET", "/secrets", (Type)((Object)SecretsList.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }
}

