/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.pulse;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.Credentials;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskclusterRequestHandler;
import org.mozilla.taskcluster.client.pulse.ListNamespacesResponse;
import org.mozilla.taskcluster.client.pulse.Namespace;
import org.mozilla.taskcluster.client.pulse.NamespaceCreationRequest;
import org.mozilla.taskcluster.client.pulse.NamespaceCreationResponse;
import org.mozilla.taskcluster.client.pulse.RabbitOverviewResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pulse
extends TaskclusterRequestHandler {
    protected static final String defaultBaseURL = "https://pulse.taskcluster.net/v1";

    public Pulse(Credentials credentials) {
        super(credentials, defaultBaseURL);
    }

    public Pulse(Credentials credentials, String baseURL) {
        super(credentials, baseURL);
    }

    public Pulse(String clientId, String accessToken) {
        super(new Credentials(clientId, accessToken), defaultBaseURL);
    }

    public Pulse(String clientId, String accessToken, String certificate) {
        super(new Credentials(clientId, accessToken, certificate), defaultBaseURL);
    }

    public Pulse(String baseURL) {
        super(baseURL);
    }

    public Pulse() {
        super(defaultBaseURL);
    }

    public CallSummary<EmptyPayload, RabbitOverviewResponse> overview() throws APICallFailure {
        return this.apiCall(null, "GET", "/overview", (Type)((Object)RabbitOverviewResponse.class));
    }

    public CallSummary<EmptyPayload, ListNamespacesResponse> listNamespaces() throws APICallFailure {
        return this.apiCall(null, "GET", "/namespaces", (Type)((Object)ListNamespacesResponse.class));
    }

    public CallSummary<EmptyPayload, Namespace> namespace(String namespace) throws APICallFailure {
        return this.apiCall(null, "GET", "/namespace/" + Pulse.uriEncode(namespace), (Type)((Object)Namespace.class));
    }

    public CallSummary<NamespaceCreationRequest, NamespaceCreationResponse> claimNamespace(String namespace, NamespaceCreationRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/namespace/" + Pulse.uriEncode(namespace), (Type)((Object)NamespaceCreationResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }
}

