/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.github;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.Credentials;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskclusterRequestHandler;
import org.mozilla.taskcluster.client.github.Builds;
import org.mozilla.taskcluster.client.github.CreateComment;
import org.mozilla.taskcluster.client.github.CreateStatus;
import org.mozilla.taskcluster.client.github.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Github
extends TaskclusterRequestHandler {
    protected static final String defaultBaseURL = "https://github.taskcluster.net/v1";

    public Github(Credentials credentials) {
        super(credentials, defaultBaseURL);
    }

    public Github(Credentials credentials, String baseURL) {
        super(credentials, baseURL);
    }

    public Github(String clientId, String accessToken) {
        super(new Credentials(clientId, accessToken), defaultBaseURL);
    }

    public Github(String clientId, String accessToken, String certificate) {
        super(new Credentials(clientId, accessToken, certificate), defaultBaseURL);
    }

    public Github(String baseURL) {
        super(baseURL);
    }

    public Github() {
        super(defaultBaseURL);
    }

    public CallSummary<EmptyPayload, EmptyPayload> githubWebHookConsumer() throws APICallFailure {
        return this.apiCall(null, "POST", "/github", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, Builds> builds() throws APICallFailure {
        return this.apiCall(null, "GET", "/builds", (Type)((Object)Builds.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> badge(String owner, String repo, String branch) throws APICallFailure {
        return this.apiCall(null, "GET", "/repository/" + Github.uriEncode(owner) + "/" + Github.uriEncode(repo) + "/" + Github.uriEncode(branch) + "/badge.svg", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, Repository> repository(String owner, String repo) throws APICallFailure {
        return this.apiCall(null, "GET", "/repository/" + Github.uriEncode(owner) + "/" + Github.uriEncode(repo), (Type)((Object)Repository.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> latest(String owner, String repo, String branch) throws APICallFailure {
        return this.apiCall(null, "GET", "/repository/" + Github.uriEncode(owner) + "/" + Github.uriEncode(repo) + "/" + Github.uriEncode(branch) + "/latest", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<CreateStatus, EmptyPayload> createStatus(String owner, String repo, String sha, CreateStatus payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/repository/" + Github.uriEncode(owner) + "/" + Github.uriEncode(repo) + "/statuses/" + Github.uriEncode(sha), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<CreateComment, EmptyPayload> createComment(String owner, String repo, String number, CreateComment payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/repository/" + Github.uriEncode(owner) + "/" + Github.uriEncode(repo) + "/issues/" + Github.uriEncode(number) + "/comments", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }
}

