/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.queue;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.Credentials;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskclusterRequestHandler;
import org.mozilla.taskcluster.client.queue.ClaimWorkRequest;
import org.mozilla.taskcluster.client.queue.ClaimWorkResponse;
import org.mozilla.taskcluster.client.queue.CountPendingTasksResponse;
import org.mozilla.taskcluster.client.queue.ListArtifactsResponse;
import org.mozilla.taskcluster.client.queue.ListDependentTasksResponse;
import org.mozilla.taskcluster.client.queue.ListProvisionersResponse;
import org.mozilla.taskcluster.client.queue.ListTaskGroupResponse;
import org.mozilla.taskcluster.client.queue.ListWorkerTypesResponse;
import org.mozilla.taskcluster.client.queue.PollTaskUrlsResponse;
import org.mozilla.taskcluster.client.queue.TaskClaimRequest;
import org.mozilla.taskcluster.client.queue.TaskClaimResponse;
import org.mozilla.taskcluster.client.queue.TaskDefinitionRequest;
import org.mozilla.taskcluster.client.queue.TaskDefinitionResponse;
import org.mozilla.taskcluster.client.queue.TaskExceptionRequest;
import org.mozilla.taskcluster.client.queue.TaskReclaimResponse;
import org.mozilla.taskcluster.client.queue.TaskStatusResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Queue
extends TaskclusterRequestHandler {
    protected static final String defaultBaseURL = "https://queue.taskcluster.net/v1";

    public Queue(Credentials credentials) {
        super(credentials, defaultBaseURL);
    }

    public Queue(Credentials credentials, String baseURL) {
        super(credentials, baseURL);
    }

    public Queue(String clientId, String accessToken) {
        super(new Credentials(clientId, accessToken), defaultBaseURL);
    }

    public Queue(String clientId, String accessToken, String certificate) {
        super(new Credentials(clientId, accessToken, certificate), defaultBaseURL);
    }

    public Queue(String baseURL) {
        super(baseURL);
    }

    public Queue() {
        super(defaultBaseURL);
    }

    public CallSummary<EmptyPayload, TaskDefinitionResponse> task(String taskId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + Queue.uriEncode(taskId), (Type)((Object)TaskDefinitionResponse.class));
    }

    public CallSummary<EmptyPayload, TaskStatusResponse> status(String taskId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + Queue.uriEncode(taskId) + "/status", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<EmptyPayload, ListTaskGroupResponse> listTaskGroup(String taskGroupId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task-group/" + Queue.uriEncode(taskGroupId) + "/list", (Type)((Object)ListTaskGroupResponse.class));
    }

    public CallSummary<EmptyPayload, ListDependentTasksResponse> listDependentTasks(String taskId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + Queue.uriEncode(taskId) + "/dependents", (Type)((Object)ListDependentTasksResponse.class));
    }

    public CallSummary<TaskDefinitionRequest, TaskStatusResponse> createTask(String taskId, TaskDefinitionRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/task/" + Queue.uriEncode(taskId), (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<TaskDefinitionRequest, TaskStatusResponse> defineTask(String taskId, TaskDefinitionRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/task/" + Queue.uriEncode(taskId) + "/define", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<EmptyPayload, TaskStatusResponse> scheduleTask(String taskId) throws APICallFailure {
        return this.apiCall(null, "POST", "/task/" + Queue.uriEncode(taskId) + "/schedule", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<EmptyPayload, TaskStatusResponse> rerunTask(String taskId) throws APICallFailure {
        return this.apiCall(null, "POST", "/task/" + Queue.uriEncode(taskId) + "/rerun", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<EmptyPayload, TaskStatusResponse> cancelTask(String taskId) throws APICallFailure {
        return this.apiCall(null, "POST", "/task/" + Queue.uriEncode(taskId) + "/cancel", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<EmptyPayload, PollTaskUrlsResponse> pollTaskUrls(String provisionerId, String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/poll-task-url/" + Queue.uriEncode(provisionerId) + "/" + Queue.uriEncode(workerType), (Type)((Object)PollTaskUrlsResponse.class));
    }

    public CallSummary<ClaimWorkRequest, ClaimWorkResponse> claimWork(String provisionerId, String workerType, ClaimWorkRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/claim-work/" + Queue.uriEncode(provisionerId) + "/" + Queue.uriEncode(workerType), (Type)((Object)ClaimWorkResponse.class));
    }

    public CallSummary<TaskClaimRequest, TaskClaimResponse> claimTask(String taskId, String runId, TaskClaimRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/task/" + Queue.uriEncode(taskId) + "/runs/" + Queue.uriEncode(runId) + "/claim", (Type)((Object)TaskClaimResponse.class));
    }

    public CallSummary<EmptyPayload, TaskReclaimResponse> reclaimTask(String taskId, String runId) throws APICallFailure {
        return this.apiCall(null, "POST", "/task/" + Queue.uriEncode(taskId) + "/runs/" + Queue.uriEncode(runId) + "/reclaim", (Type)((Object)TaskReclaimResponse.class));
    }

    public CallSummary<EmptyPayload, TaskStatusResponse> reportCompleted(String taskId, String runId) throws APICallFailure {
        return this.apiCall(null, "POST", "/task/" + Queue.uriEncode(taskId) + "/runs/" + Queue.uriEncode(runId) + "/completed", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<EmptyPayload, TaskStatusResponse> reportFailed(String taskId, String runId) throws APICallFailure {
        return this.apiCall(null, "POST", "/task/" + Queue.uriEncode(taskId) + "/runs/" + Queue.uriEncode(runId) + "/failed", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<TaskExceptionRequest, TaskStatusResponse> reportException(String taskId, String runId, TaskExceptionRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/task/" + Queue.uriEncode(taskId) + "/runs/" + Queue.uriEncode(runId) + "/exception", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<Object, Object> createArtifact(String taskId, String runId, String name, Object payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/task/" + Queue.uriEncode(taskId) + "/runs/" + Queue.uriEncode(runId) + "/artifacts/" + Queue.uriEncode(name), (Type)((Object)Object.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> getArtifact(String taskId, String runId, String name) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + Queue.uriEncode(taskId) + "/runs/" + Queue.uriEncode(runId) + "/artifacts/" + Queue.uriEncode(name), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> getLatestArtifact(String taskId, String name) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + Queue.uriEncode(taskId) + "/artifacts/" + Queue.uriEncode(name), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, ListArtifactsResponse> listArtifacts(String taskId, String runId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + Queue.uriEncode(taskId) + "/runs/" + Queue.uriEncode(runId) + "/artifacts", (Type)((Object)ListArtifactsResponse.class));
    }

    public CallSummary<EmptyPayload, ListArtifactsResponse> listLatestArtifacts(String taskId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + Queue.uriEncode(taskId) + "/artifacts", (Type)((Object)ListArtifactsResponse.class));
    }

    public CallSummary<EmptyPayload, ListProvisionersResponse> listProvisioners() throws APICallFailure {
        return this.apiCall(null, "GET", "/provisioners", (Type)((Object)ListProvisionersResponse.class));
    }

    public CallSummary<EmptyPayload, CountPendingTasksResponse> pendingTasks(String provisionerId, String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/pending/" + Queue.uriEncode(provisionerId) + "/" + Queue.uriEncode(workerType), (Type)((Object)CountPendingTasksResponse.class));
    }

    public CallSummary<EmptyPayload, ListWorkerTypesResponse> listWorkerTypes(String provisionerId) throws APICallFailure {
        return this.apiCall(null, "GET", "/provisioners/" + Queue.uriEncode(provisionerId) + "/worker-types", (Type)((Object)ListWorkerTypesResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }
}

