/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.hooks;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.Credentials;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskClusterRequestHandler;
import org.mozilla.taskcluster.client.hooks.HookCreationRequest;
import org.mozilla.taskcluster.client.hooks.HookDefinition;
import org.mozilla.taskcluster.client.hooks.HookGroups;
import org.mozilla.taskcluster.client.hooks.HookList;
import org.mozilla.taskcluster.client.hooks.HookScheduleResponse;
import org.mozilla.taskcluster.client.hooks.HookStatusResponse;
import org.mozilla.taskcluster.client.hooks.TaskStatusStructure;
import org.mozilla.taskcluster.client.hooks.TriggerTokenResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hooks
extends TaskClusterRequestHandler {
    protected static final String defaultBaseURL = "https://hooks.taskcluster.net/v1";

    public Hooks(Credentials credentials) {
        super(credentials, defaultBaseURL);
    }

    public Hooks(Credentials credentials, String baseURL) {
        super(credentials, baseURL);
    }

    public Hooks(String clientId, String accessToken) {
        super(new Credentials(clientId, accessToken), defaultBaseURL);
    }

    public Hooks(String clientId, String accessToken, String certificate) {
        super(new Credentials(clientId, accessToken, certificate), defaultBaseURL);
    }

    public Hooks(String baseURL) {
        super(baseURL);
    }

    public Hooks() {
        super(defaultBaseURL);
    }

    public CallSummary<EmptyPayload, HookGroups> listHookGroups() throws APICallFailure {
        return this.apiCall(null, "GET", "/hooks", (Type)((Object)HookGroups.class));
    }

    public CallSummary<EmptyPayload, HookList> listHooks(String hookGroupId) throws APICallFailure {
        return this.apiCall(null, "GET", "/hooks/" + Hooks.uriEncode(hookGroupId), (Type)((Object)HookList.class));
    }

    public CallSummary<EmptyPayload, HookDefinition> hook(String hookGroupId, String hookId) throws APICallFailure {
        return this.apiCall(null, "GET", "/hooks/" + Hooks.uriEncode(hookGroupId) + "/" + Hooks.uriEncode(hookId), (Type)((Object)HookDefinition.class));
    }

    public CallSummary<EmptyPayload, HookStatusResponse> getHookStatus(String hookGroupId, String hookId) throws APICallFailure {
        return this.apiCall(null, "GET", "/hooks/" + Hooks.uriEncode(hookGroupId) + "/" + Hooks.uriEncode(hookId) + "/status", (Type)((Object)HookStatusResponse.class));
    }

    public CallSummary<EmptyPayload, HookScheduleResponse> getHookSchedule(String hookGroupId, String hookId) throws APICallFailure {
        return this.apiCall(null, "GET", "/hooks/" + Hooks.uriEncode(hookGroupId) + "/" + Hooks.uriEncode(hookId) + "/schedule", (Type)((Object)HookScheduleResponse.class));
    }

    public CallSummary<HookCreationRequest, HookDefinition> createHook(String hookGroupId, String hookId, HookCreationRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/hooks/" + Hooks.uriEncode(hookGroupId) + "/" + Hooks.uriEncode(hookId), (Type)((Object)HookDefinition.class));
    }

    public CallSummary<HookCreationRequest, HookDefinition> updateHook(String hookGroupId, String hookId, HookCreationRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/hooks/" + Hooks.uriEncode(hookGroupId) + "/" + Hooks.uriEncode(hookId), (Type)((Object)HookDefinition.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> removeHook(String hookGroupId, String hookId) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/hooks/" + Hooks.uriEncode(hookGroupId) + "/" + Hooks.uriEncode(hookId), (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<Object, TaskStatusStructure> triggerHook(String hookGroupId, String hookId, Object payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/hooks/" + Hooks.uriEncode(hookGroupId) + "/" + Hooks.uriEncode(hookId) + "/trigger", (Type)((Object)TaskStatusStructure.class));
    }

    public CallSummary<EmptyPayload, TriggerTokenResponse> getTriggerToken(String hookGroupId, String hookId) throws APICallFailure {
        return this.apiCall(null, "GET", "/hooks/" + Hooks.uriEncode(hookGroupId) + "/" + Hooks.uriEncode(hookId) + "/token", (Type)((Object)TriggerTokenResponse.class));
    }

    public CallSummary<EmptyPayload, TriggerTokenResponse> resetTriggerToken(String hookGroupId, String hookId) throws APICallFailure {
        return this.apiCall(null, "POST", "/hooks/" + Hooks.uriEncode(hookGroupId) + "/" + Hooks.uriEncode(hookId) + "/token", (Type)((Object)TriggerTokenResponse.class));
    }

    public CallSummary<Object, TaskStatusStructure> triggerHookWithToken(String hookGroupId, String hookId, String token, Object payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/hooks/" + Hooks.uriEncode(hookGroupId) + "/" + Hooks.uriEncode(hookId) + "/trigger/" + Hooks.uriEncode(token), (Type)((Object)TaskStatusStructure.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }
}

