/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.queue;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskClusterRequestHandler;
import org.mozilla.taskcluster.client.queue.CountPendingTasksResponse;
import org.mozilla.taskcluster.client.queue.ListArtifactsResponse;
import org.mozilla.taskcluster.client.queue.PollTaskUrlsResponse;
import org.mozilla.taskcluster.client.queue.TaskClaimRequest;
import org.mozilla.taskcluster.client.queue.TaskClaimResponse;
import org.mozilla.taskcluster.client.queue.TaskDefinition;
import org.mozilla.taskcluster.client.queue.TaskDefinition1;
import org.mozilla.taskcluster.client.queue.TaskExceptionRequest;
import org.mozilla.taskcluster.client.queue.TaskStatusResponse;

public class Queue
extends TaskClusterRequestHandler {
    protected static final String defaultBaseURL = "https://queue.taskcluster.net/v1";

    public Queue(String clientId, String accessToken) {
        super(clientId, accessToken, defaultBaseURL);
    }

    public Queue(String clientId, String accessToken, String certificate) {
        super(clientId, accessToken, certificate, defaultBaseURL);
    }

    public Queue(String baseURL) {
        super(baseURL);
    }

    public CallSummary<EmptyPayload, TaskDefinition1> task(String taskId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + taskId + "", (Type)((Object)TaskDefinition1.class));
    }

    public CallSummary<EmptyPayload, TaskStatusResponse> status(String taskId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + taskId + "/status", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<TaskDefinition, TaskStatusResponse> createTask(String taskId, TaskDefinition payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/task/" + taskId + "", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<TaskDefinition, TaskStatusResponse> defineTask(String taskId, TaskDefinition payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/task/" + taskId + "/define", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<EmptyPayload, TaskStatusResponse> scheduleTask(String taskId) throws APICallFailure {
        return this.apiCall(null, "POST", "/task/" + taskId + "/schedule", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<EmptyPayload, TaskStatusResponse> rerunTask(String taskId) throws APICallFailure {
        return this.apiCall(null, "POST", "/task/" + taskId + "/rerun", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<EmptyPayload, TaskStatusResponse> cancelTask(String taskId) throws APICallFailure {
        return this.apiCall(null, "POST", "/task/" + taskId + "/cancel", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<EmptyPayload, PollTaskUrlsResponse> pollTaskUrls(String provisionerId, String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/poll-task-url/" + provisionerId + "/" + workerType + "", (Type)((Object)PollTaskUrlsResponse.class));
    }

    public CallSummary<TaskClaimRequest, TaskClaimResponse> claimTask(String taskId, String runId, TaskClaimRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/task/" + taskId + "/runs/" + runId + "/claim", (Type)((Object)TaskClaimResponse.class));
    }

    public CallSummary<EmptyPayload, TaskClaimResponse> reclaimTask(String taskId, String runId) throws APICallFailure {
        return this.apiCall(null, "POST", "/task/" + taskId + "/runs/" + runId + "/reclaim", (Type)((Object)TaskClaimResponse.class));
    }

    public CallSummary<EmptyPayload, TaskStatusResponse> reportCompleted(String taskId, String runId) throws APICallFailure {
        return this.apiCall(null, "POST", "/task/" + taskId + "/runs/" + runId + "/completed", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<EmptyPayload, TaskStatusResponse> reportFailed(String taskId, String runId) throws APICallFailure {
        return this.apiCall(null, "POST", "/task/" + taskId + "/runs/" + runId + "/failed", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<TaskExceptionRequest, TaskStatusResponse> reportException(String taskId, String runId, TaskExceptionRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/task/" + taskId + "/runs/" + runId + "/exception", (Type)((Object)TaskStatusResponse.class));
    }

    public CallSummary<Object, Object> createArtifact(String taskId, String runId, String name, Object payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/task/" + taskId + "/runs/" + runId + "/artifacts/" + name + "", (Type)((Object)Object.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> getArtifact(String taskId, String runId, String name) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + taskId + "/runs/" + runId + "/artifacts/" + name + "", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> getLatestArtifact(String taskId, String name) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + taskId + "/artifacts/" + name + "", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, ListArtifactsResponse> listArtifacts(String taskId, String runId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + taskId + "/runs/" + runId + "/artifacts", (Type)((Object)ListArtifactsResponse.class));
    }

    public CallSummary<EmptyPayload, ListArtifactsResponse> listLatestArtifacts(String taskId) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + taskId + "/artifacts", (Type)((Object)ListArtifactsResponse.class));
    }

    public CallSummary<EmptyPayload, CountPendingTasksResponse> pendingTasks(String provisionerId, String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/pending/" + provisionerId + "/" + workerType + "", (Type)((Object)CountPendingTasksResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }
}

