/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.index;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskClusterRequestHandler;
import org.mozilla.taskcluster.client.index.IndexedTaskResponse;
import org.mozilla.taskcluster.client.index.InsertTaskRequest;
import org.mozilla.taskcluster.client.index.ListNamespacesRequest;
import org.mozilla.taskcluster.client.index.ListNamespacesResponse;
import org.mozilla.taskcluster.client.index.ListTasksRequest;
import org.mozilla.taskcluster.client.index.ListTasksResponse;

public class Index
extends TaskClusterRequestHandler {
    protected static final String defaultBaseURL = "https://index.taskcluster.net/v1";

    public Index(String clientId, String accessToken) {
        super(clientId, accessToken, defaultBaseURL);
    }

    public Index(String clientId, String accessToken, String certificate) {
        super(clientId, accessToken, certificate, defaultBaseURL);
    }

    public Index(String baseURL) {
        super(baseURL);
    }

    public CallSummary<EmptyPayload, IndexedTaskResponse> findTask(String namespace) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + namespace + "", (Type)((Object)IndexedTaskResponse.class));
    }

    public CallSummary<ListNamespacesRequest, ListNamespacesResponse> listNamespaces(String namespace, ListNamespacesRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/namespaces/" + namespace + "", (Type)((Object)ListNamespacesResponse.class));
    }

    public CallSummary<ListTasksRequest, ListTasksResponse> listTasks(String namespace, ListTasksRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/tasks/" + namespace + "", (Type)((Object)ListTasksResponse.class));
    }

    public CallSummary<InsertTaskRequest, IndexedTaskResponse> insertTask(String namespace, InsertTaskRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/task/" + namespace + "", (Type)((Object)IndexedTaskResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> findArtifactFromTask(String namespace, String name) throws APICallFailure {
        return this.apiCall(null, "GET", "/task/" + namespace + "/artifacts/" + name + "", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }
}

