/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.awsprovisioner;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskClusterRequestHandler;
import org.mozilla.taskcluster.client.awsprovisioner.CreateWorkerTypeRequest;
import org.mozilla.taskcluster.client.awsprovisioner.GetSecretRequest;
import org.mozilla.taskcluster.client.awsprovisioner.GetSecretResponse;
import org.mozilla.taskcluster.client.awsprovisioner.GetWorkerTypeRequest;

public class AwsProvisioner
extends TaskClusterRequestHandler {
    protected static final String defaultBaseURL = "https://aws-provisioner.taskcluster.net/v1";

    public AwsProvisioner(String clientId, String accessToken) {
        super(clientId, accessToken, defaultBaseURL);
    }

    public AwsProvisioner(String clientId, String accessToken, String certificate) {
        super(clientId, accessToken, certificate, defaultBaseURL);
    }

    public AwsProvisioner(String baseURL) {
        super(baseURL);
    }

    public CallSummary<CreateWorkerTypeRequest, GetWorkerTypeRequest> createWorkerType(String workerType, CreateWorkerTypeRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/worker-type/" + workerType + "", (Type)((Object)GetWorkerTypeRequest.class));
    }

    public CallSummary<CreateWorkerTypeRequest, GetWorkerTypeRequest> updateWorkerType(String workerType, CreateWorkerTypeRequest payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/worker-type/" + workerType + "/update", (Type)((Object)GetWorkerTypeRequest.class));
    }

    public CallSummary<EmptyPayload, GetWorkerTypeRequest> workerType(String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/worker-type/" + workerType + "", (Type)((Object)GetWorkerTypeRequest.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> removeWorkerType(String workerType) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/worker-type/" + workerType + "", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, String[]> listWorkerTypes() throws APICallFailure {
        return this.apiCall(null, "GET", "/list-worker-types", (Type)((Object)String[].class));
    }

    public CallSummary<GetSecretRequest, EmptyPayload> createSecret(String token, GetSecretRequest payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/secret/" + token + "", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, GetSecretResponse> getSecret(String token) throws APICallFailure {
        return this.apiCall(null, "GET", "/secret/" + token + "", (Type)((Object)GetSecretResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> instanceStarted(String instanceId, String token) throws APICallFailure {
        return this.apiCall(null, "GET", "/instance-started/" + instanceId + "/" + token + "", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> removeSecret(String token) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/secret/" + token + "", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, Object> getLaunchSpecs(String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/worker-type/" + workerType + "/launch-specifications", (Type)((Object)Object.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> awsState() throws APICallFailure {
        return this.apiCall(null, "GET", "/aws-state", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> state(String workerType) throws APICallFailure {
        return this.apiCall(null, "GET", "/state/" + workerType + "", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> apiReference() throws APICallFailure {
        return this.apiCall(null, "GET", "/api-reference", (Type)((Object)EmptyPayload.class));
    }
}

