/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.taskcluster.client.auth;

import java.lang.reflect.Type;
import org.mozilla.taskcluster.client.APICallFailure;
import org.mozilla.taskcluster.client.CallSummary;
import org.mozilla.taskcluster.client.EmptyPayload;
import org.mozilla.taskcluster.client.TaskClusterRequestHandler;
import org.mozilla.taskcluster.client.auth.AWSS3CredentialsResponse;
import org.mozilla.taskcluster.client.auth.AzureSharedAccessSignatureResponse;
import org.mozilla.taskcluster.client.auth.ExportedClients;
import org.mozilla.taskcluster.client.auth.GetClientCredentialsResponse;
import org.mozilla.taskcluster.client.auth.GetClientCredentialsResponse1;
import org.mozilla.taskcluster.client.auth.GetClientResponse;
import org.mozilla.taskcluster.client.auth.GetClientScopesResponse;
import org.mozilla.taskcluster.client.auth.ListClientsResponse;

public class Auth
extends TaskClusterRequestHandler {
    protected static final String defaultBaseURL = "https://auth.taskcluster.net/v1";

    public Auth(String clientId, String accessToken) {
        super(clientId, accessToken, defaultBaseURL);
    }

    public Auth(String clientId, String accessToken, String certificate) {
        super(clientId, accessToken, certificate, defaultBaseURL);
    }

    public Auth(String baseURL) {
        super(baseURL);
    }

    public CallSummary<EmptyPayload, GetClientScopesResponse> scopes(String clientId) throws APICallFailure {
        return this.apiCall(null, "GET", "/client/" + clientId + "/scopes", (Type)((Object)GetClientScopesResponse.class));
    }

    public CallSummary<EmptyPayload, GetClientCredentialsResponse> getCredentials(String clientId) throws APICallFailure {
        return this.apiCall(null, "GET", "/client/" + clientId + "/credentials", (Type)((Object)GetClientCredentialsResponse.class));
    }

    public CallSummary<EmptyPayload, GetClientResponse> client(String clientId) throws APICallFailure {
        return this.apiCall(null, "GET", "/client/" + clientId + "", (Type)((Object)GetClientResponse.class));
    }

    public CallSummary<GetClientCredentialsResponse1, GetClientResponse> createClient(String clientId, GetClientCredentialsResponse1 payload) throws APICallFailure {
        return this.apiCall(payload, "PUT", "/client/" + clientId + "", (Type)((Object)GetClientResponse.class));
    }

    public CallSummary<GetClientCredentialsResponse1, GetClientResponse> modifyClient(String clientId, GetClientCredentialsResponse1 payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/client/" + clientId + "/modify", (Type)((Object)GetClientResponse.class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> removeClient(String clientId) throws APICallFailure {
        return this.apiCall(null, "DELETE", "/client/" + clientId + "", (Type)((Object)EmptyPayload.class));
    }

    public CallSummary<EmptyPayload, GetClientResponse> resetCredentials(String clientId) throws APICallFailure {
        return this.apiCall(null, "POST", "/client/" + clientId + "/reset-credentials", (Type)((Object)GetClientResponse.class));
    }

    public CallSummary<EmptyPayload, ListClientsResponse[]> listClients() throws APICallFailure {
        return this.apiCall(null, "GET", "/list-clients", (Type)((Object)ListClientsResponse[].class));
    }

    public CallSummary<EmptyPayload, AzureSharedAccessSignatureResponse> azureTableSAS(String account, String table) throws APICallFailure {
        return this.apiCall(null, "GET", "/azure/" + account + "/table/" + table + "/read-write", (Type)((Object)AzureSharedAccessSignatureResponse.class));
    }

    public CallSummary<EmptyPayload, AWSS3CredentialsResponse> awsS3Credentials(String level, String bucket, String prefix) throws APICallFailure {
        return this.apiCall(null, "GET", "/aws/s3/" + level + "/" + bucket + "/" + prefix + "", (Type)((Object)AWSS3CredentialsResponse.class));
    }

    public CallSummary<EmptyPayload, ExportedClients[]> exportClients() throws APICallFailure {
        return this.apiCall(null, "GET", "/export-clients", (Type)((Object)ExportedClients[].class));
    }

    public CallSummary<ExportedClients, ExportedClients[]> importClients(ExportedClients payload) throws APICallFailure {
        return this.apiCall(payload, "POST", "/import-clients", (Type)((Object)ExportedClients[].class));
    }

    public CallSummary<EmptyPayload, EmptyPayload> ping() throws APICallFailure {
        return this.apiCall(null, "GET", "/ping", (Type)((Object)EmptyPayload.class));
    }
}

