/*
 * Decompiled with CFR 0.152.
 */
package org.mountcloud.springcloud.common.mongo.repository.listener;

import java.lang.reflect.Field;
import java.util.Date;
import org.mountcloud.springcloud.common.mongo.repository.keys.SeqInfo;
import org.mountcloud.springproject.common.entity.BaseEntity;
import org.mountcloud.springproject.common.entity.annotation.EntityId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.FindAndModifyOptions;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.mapping.event.AbstractMongoEventListener;
import org.springframework.data.mongodb.core.mapping.event.BeforeConvertEvent;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.util.ReflectionUtils;

@Component
public class SaveEventListener
extends AbstractMongoEventListener<Object> {
    @Autowired
    private MongoTemplate mongo;

    public void onBeforeConvert(BeforeConvertEvent<Object> event) {
        final Object source = event.getSource();
        if (source != null) {
            if (source instanceof BaseEntity) {
                Date date = new Date();
                BaseEntity tempEntity = (BaseEntity)source;
                if (tempEntity.getId() == null) {
                    if (tempEntity.getCreateTime() == null) {
                        tempEntity.setCreateTime(date);
                    }
                    if (tempEntity.getUpdateTime() == null) {
                        tempEntity.setUpdateTime(date);
                    }
                } else {
                    tempEntity.setUpdateTime(date);
                }
            }
            ReflectionUtils.doWithFields(source.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                    Object value;
                    ReflectionUtils.makeAccessible((Field)field);
                    if (field.isAnnotationPresent(EntityId.class) && (value = field.get(source)) == null) {
                        field.set(source, SaveEventListener.this.getNextId(source.getClass().getSimpleName()));
                    }
                }
            });
        }
    }

    private Long getNextId(String collName) {
        Query query = new Query((CriteriaDefinition)Criteria.where((String)"collName").is((Object)collName));
        Update update = new Update();
        update.inc("seqId", (Number)1);
        FindAndModifyOptions options = new FindAndModifyOptions();
        options.upsert(true);
        options.returnNew(true);
        SeqInfo seq = (SeqInfo)this.mongo.findAndModify(query, update, options, SeqInfo.class);
        return seq.getSeqId();
    }
}

