/*
 * Decompiled with CFR 0.152.
 */
package org.mountcloud.springcloud.common.mongo.config;

import com.mongodb.ReadPreference;
import org.mountcloud.springcloud.common.mongo.setting.MongoSetting;
import org.mountcloud.springproject.common.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mongodb.MongoDbFactory;
import org.springframework.data.mongodb.core.MongoClientOptionsFactoryBean;
import org.springframework.data.mongodb.core.convert.DbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultDbRefResolver;
import org.springframework.data.mongodb.core.convert.DefaultMongoTypeMapper;
import org.springframework.data.mongodb.core.convert.MappingMongoConverter;
import org.springframework.data.mongodb.core.convert.MongoTypeMapper;
import org.springframework.data.mongodb.core.mapping.MongoMappingContext;

public class MongoConfig {
    @Autowired
    @Lazy
    private MongoSetting setting;
    private MongoDbFactory mongoDbFactory;
    private MongoMappingContext mongoMappingContext;

    public MongoDbFactory getMongoDbFactory() {
        return this.mongoDbFactory;
    }

    @Autowired
    public void setMongoDbFactory(@Lazy MongoDbFactory mongoDbFactory) {
        this.mongoDbFactory = mongoDbFactory;
    }

    public MongoMappingContext getMongoMappingContext() {
        return this.mongoMappingContext;
    }

    @Autowired
    public void setMongoMappingContext(@Lazy MongoMappingContext mongoMappingContext) {
        this.mongoMappingContext = mongoMappingContext;
    }

    @Bean
    @Lazy
    public MongoClientOptionsFactoryBean mongoClientOptionFactoryBeanProd() {
        MongoClientOptionsFactoryBean bean = new MongoClientOptionsFactoryBean();
        bean.setConnectionsPerHost(this.setting.getConnectionsPerHost());
        bean.setConnectTimeout(this.setting.getConnectTimeout());
        bean.setHeartbeatConnectTimeout(this.setting.getHeartbeatConnectTimeout());
        bean.setMaxConnectionIdleTime(this.setting.getMaxConnectionIdleTime());
        bean.setMaxConnectionLifeTime(this.setting.getMaxConnectionLifeTime());
        bean.setMinConnectionsPerHost(this.setting.getMinConnectionsPerHost());
        bean.setReadPreference(ReadPreference.secondary());
        if (!StringUtil.isEmpty((CharSequence)this.setting.getRequiredReplicaSetName())) {
            bean.setRequiredReplicaSetName(this.setting.getRequiredReplicaSetName());
        }
        bean.setMinHeartbeatFrequency(this.setting.getMinHeartbeatFrequency());
        bean.setHeartbeatSocketTimeout(this.setting.getHeartbeatSocketTimeout());
        bean.setSocketKeepAlive(this.setting.isSocketKeepAlive());
        bean.setThreadsAllowedToBlockForConnectionMultiplier(this.setting.getThreadsAllowedToBlockForConnectionMultiplier());
        return bean;
    }

    @Bean
    @Lazy
    public MappingMongoConverter mappingMongoConverter() {
        DefaultDbRefResolver dbRefResolver = new DefaultDbRefResolver(this.getMongoDbFactory());
        MappingMongoConverter converter = new MappingMongoConverter((DbRefResolver)dbRefResolver, (MappingContext)this.getMongoMappingContext());
        converter.setTypeMapper((MongoTypeMapper)new DefaultMongoTypeMapper(null));
        return converter;
    }
}

