/*
 * Decompiled with CFR 0.152.
 */
package org.mountcloud.mybatisplugin.utils;

import java.util.ArrayList;
import java.util.List;
import org.mybatis.generator.api.CommentGenerator;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.dom.java.Field;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.Method;
import org.mybatis.generator.api.dom.java.Parameter;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.XmlElement;
import org.mybatis.generator.codegen.AbstractJavaGenerator;
import org.mybatis.generator.config.Context;

public class MybatisPluginUtil {
    public static void addField(Context context, TopLevelClass topLevelClass, IntrospectedTable introspectedTable, String name, FullyQualifiedJavaType javaType, boolean packing) {
        CommentGenerator commentGenerator = context.getCommentGenerator();
        Field field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(javaType);
        field.setName(name);
        commentGenerator.addFieldComment(field, introspectedTable);
        topLevelClass.addField(field);
        char c = name.charAt(0);
        String camel = Character.toUpperCase(c) + name.substring(1);
        if (packing) {
            Method method = new Method();
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setName("set" + camel);
            method.addParameter(new Parameter(javaType, name));
            StringBuilder sb = new StringBuilder();
            sb.append("this.");
            sb.append(name);
            sb.append(" = ");
            sb.append(name);
            sb.append(";");
            method.addBodyLine(sb.toString());
            commentGenerator.addGeneralMethodComment(method, introspectedTable);
            topLevelClass.addMethod(method);
            Method getterMethod = AbstractJavaGenerator.getGetter((Field)field);
            commentGenerator.addGeneralMethodComment(getterMethod, introspectedTable);
            topLevelClass.addMethod(getterMethod);
        }
    }

    public static void addField(Context context, InnerClass innerClass, IntrospectedTable introspectedTable, String name, FullyQualifiedJavaType javaType, boolean packing) {
        CommentGenerator commentGenerator = context.getCommentGenerator();
        Field field = new Field();
        field.setVisibility(JavaVisibility.PROTECTED);
        field.setType(javaType);
        field.setName(name);
        commentGenerator.addFieldComment(field, introspectedTable);
        innerClass.addField(field);
        char c = name.charAt(0);
        String camel = Character.toUpperCase(c) + name.substring(1);
        if (packing) {
            Method method = new Method();
            method.setVisibility(JavaVisibility.PUBLIC);
            method.setName("set" + camel);
            method.addParameter(new Parameter(javaType, name));
            StringBuilder sb = new StringBuilder();
            sb.append("this.");
            sb.append(name);
            sb.append(" = ");
            sb.append(name);
            sb.append(";");
            method.addBodyLine(sb.toString());
            commentGenerator.addGeneralMethodComment(method, introspectedTable);
            innerClass.addMethod(method);
            Method getterMethod = AbstractJavaGenerator.getGetter((Field)field);
            commentGenerator.addGeneralMethodComment(getterMethod, introspectedTable);
            innerClass.addMethod(getterMethod);
        }
    }

    public static List<XmlElement> getElement(XmlElement element, String name) {
        ArrayList<XmlElement> result = new ArrayList<XmlElement>();
        List elements = element.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            XmlElement xmlElement;
            Element tempElement = (Element)elements.get(i);
            if (!(tempElement instanceof XmlElement) || !(xmlElement = (XmlElement)tempElement).getName().equals(name)) continue;
            result.add(xmlElement);
        }
        return result;
    }

    public static Attribute getAttribute(XmlElement xmlElement, String name) {
        List elementAttributes = xmlElement.getAttributes();
        for (int i = 0; i < elementAttributes.size(); ++i) {
            Attribute attribute = (Attribute)elementAttributes.get(i);
            if (!attribute.getName().equals(name)) continue;
            return attribute;
        }
        return null;
    }
}

