/*
 * Decompiled with CFR 0.152.
 */
package org.mountcloud.mybatisplugin;

import java.lang.reflect.Field;
import java.util.List;
import org.mountcloud.mybatisplugin.exception.MybatisMySqlLimitPluginException;
import org.mountcloud.mybatisplugin.utils.MybatisPluginUtil;
import org.mountcloud.mybatisplugin.utils.ObjectUtil;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.InnerClass;
import org.mybatis.generator.api.dom.java.JavaVisibility;
import org.mybatis.generator.api.dom.java.PrimitiveTypeWrapper;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.api.dom.xml.Attribute;
import org.mybatis.generator.api.dom.xml.Document;
import org.mybatis.generator.api.dom.xml.Element;
import org.mybatis.generator.api.dom.xml.TextElement;
import org.mybatis.generator.api.dom.xml.XmlElement;

public class MybatisMySqlLimitPlugin
extends PluginAdapter {
    public boolean validate(List<String> warnings) {
        return true;
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        InnerClass limitClass = new InnerClass("Limit");
        limitClass.setStatic(true);
        limitClass.setVisibility(JavaVisibility.PUBLIC);
        MybatisPluginUtil.addField(this.context, limitClass, introspectedTable, "start", (FullyQualifiedJavaType)PrimitiveTypeWrapper.getIntegerInstance(), true);
        MybatisPluginUtil.addField(this.context, limitClass, introspectedTable, "size", (FullyQualifiedJavaType)PrimitiveTypeWrapper.getIntegerInstance(), true);
        topLevelClass.addInnerClass(limitClass);
        MybatisPluginUtil.addField(this.context, topLevelClass, introspectedTable, "limit", new FullyQualifiedJavaType("Limit"), true);
        return super.modelExampleClassGenerated(topLevelClass, introspectedTable);
    }

    public boolean sqlMapDocumentGenerated(Document document, IntrospectedTable introspectedTable) {
        XmlElement parentElement = document.getRootElement();
        List<XmlElement> elements = MybatisPluginUtil.getElement(parentElement, "select");
        if (elements.size() > 0) {
            for (int i = 0; i < elements.size(); ++i) {
                XmlElement xmlElement = elements.get(i);
                Attribute attribute = MybatisPluginUtil.getAttribute(xmlElement, "id");
                if (attribute == null || !attribute.getValue().contains("ByExample")) continue;
                this.appendLimit(xmlElement);
            }
        }
        return super.sqlMapDocumentGenerated(document, introspectedTable);
    }

    private void appendLimit(XmlElement element) {
        XmlElement limitElement = new XmlElement("if");
        limitElement.addAttribute(new Attribute("test", "limit != null and limit.start != null and limit.size != null"));
        limitElement.addElement((Element)new TextElement("limit ${limit.start},${limit.size}"));
        element.addElement(element.getElements().size(), (Element)limitElement);
    }

    private boolean checkSuperClasslimit(TopLevelClass topLevelClass) {
        FullyQualifiedJavaType fullyQualifiedJavaType = topLevelClass.getSuperClass();
        boolean state = true;
        if (fullyQualifiedJavaType != null) {
            String fullyQualifiedName = fullyQualifiedJavaType.getFullyQualifiedName();
            try {
                Class<?> superClass = Class.forName(fullyQualifiedName);
                Field limitField = ObjectUtil.getField(superClass, "limit");
                if (limitField != null) {
                    Class<?> limitClass = limitField.getType();
                    Field limitStartField = ObjectUtil.getField(limitClass, "start");
                    if (limitStartField == null) {
                        throw new MybatisMySqlLimitPluginException(fullyQualifiedName + " not found start field!");
                    }
                    if (!limitStartField.getType().equals(Integer.class) && !limitStartField.getType().getName().equals("int")) {
                        throw new MybatisMySqlLimitPluginException(fullyQualifiedName + " start field type not is Integer or int!");
                    }
                    Field limitSizeField = ObjectUtil.getField(limitClass, "size");
                    if (limitSizeField == null) {
                        throw new MybatisMySqlLimitPluginException(fullyQualifiedName + " not found size field!");
                    }
                    if (!limitSizeField.getType().equals(Integer.class) && !limitSizeField.getType().getName().equals("int")) {
                        throw new MybatisMySqlLimitPluginException(fullyQualifiedName + " size field type not is Integer or int!");
                    }
                } else {
                    state = false;
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return state;
    }
}

