/*
 * Decompiled with CFR 0.152.
 */
package org.mountcloud.mybatisplugin;

import java.util.List;
import org.mybatis.generator.api.IntrospectedTable;
import org.mybatis.generator.api.PluginAdapter;
import org.mybatis.generator.api.dom.java.FullyQualifiedJavaType;
import org.mybatis.generator.api.dom.java.TopLevelClass;
import org.mybatis.generator.internal.util.StringUtility;

public class MybatisExampleRootPlugin
extends PluginAdapter {
    private String baseClassName;

    public boolean validate(List<String> warnings) {
        this.baseClassName = this.properties.getProperty("exampleRootClass");
        boolean isValid = StringUtility.stringHasValue((String)this.baseClassName);
        if (!isValid) {
            warnings.add("ExampleClassRoot plugin: exampleRootClass property not found");
        }
        return isValid;
    }

    public boolean modelExampleClassGenerated(TopLevelClass topLevelClass, IntrospectedTable introspectedTable) {
        if (this.baseClassName != null) {
            FullyQualifiedJavaType superClass = new FullyQualifiedJavaType(this.baseClassName);
            topLevelClass.addImportedType(superClass);
            topLevelClass.setSuperClass(superClass);
            System.out.println("Setting Example class " + topLevelClass.getType().getFullyQualifiedName() + " super class to " + superClass.getFullyQualifiedName());
        }
        return true;
    }
}

