/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.connectors.rest;

import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.client.urlconnection.HTTPSProperties;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.moskito.central.connectors.rest.RESTConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTHttpsConnector
extends RESTConnector {
    private static final Logger log = LoggerFactory.getLogger(RESTHttpsConnector.class);

    @Override
    protected ClientConfig getClientConfig() {
        ClientConfig clientConfig = super.getClientConfig();
        clientConfig.getProperties().put("com.sun.jersey.client.impl.urlconnection.httpsProperties", this.getHttpsProperties());
        return clientConfig;
    }

    private HTTPSProperties getHttpsProperties() {
        return new HTTPSProperties(this.getHostnameVerifier(), this.getSslContext());
    }

    private HostnameVerifier getHostnameVerifier() {
        if (this.getConnectorConfig().isHostVerificationEnabled()) {
            return new BrowserCompatHostnameVerifier();
        }
        return new AllowAllHostnameVerifier();
    }

    private SSLContext getSslContext() {
        SSLContext sslContext;
        block21: {
            sslContext = null;
            SSLContextBuilder builder = new SSLContextBuilder();
            File storeFile = null;
            FileInputStream storeStream = null;
            try {
                try {
                    if (StringUtils.isNotEmpty((String)this.getConnectorConfig().getTrustStoreFilePath())) {
                        storeFile = new File(this.getConnectorConfig().getTrustStoreFilePath());
                    }
                    if (storeFile != null && storeFile.exists()) {
                        storeStream = new FileInputStream(storeFile);
                        KeyStore trustStore = KeyStore.getInstance("JKS");
                        trustStore.load(storeStream, this.getConnectorConfig().getTrustStorePassword().toCharArray());
                        if (this.getConnectorConfig().isTrustSelfSigned()) {
                            builder.loadTrustMaterial(trustStore, (TrustStrategy)new TrustSelfSignedStrategy());
                        } else {
                            builder.loadTrustMaterial(trustStore);
                        }
                    } else if (this.getConnectorConfig().isTrustSelfSigned()) {
                        builder.loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
                    } else {
                        builder.loadTrustMaterial(null);
                    }
                    sslContext = builder.useTLS().build();
                }
                catch (Exception e) {
                    log.error("Error while initializing SSL context: " + e.getMessage(), (Throwable)e);
                    if (storeStream != null) {
                        try {
                            storeStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (storeStream != null) {
                    try {
                        storeStream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (storeStream != null) {
                try {
                    storeStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sslContext;
    }

    @Override
    protected URI getBaseURI() {
        return UriBuilder.fromUri((String)("https://" + this.getConnectorConfig().getHost() + this.getConnectorConfig().getResourcePath())).port(this.getConnectorConfig().getPort()).build(new Object[0]);
    }
}

