/*
 * Decompiled with CFR 0.152.
 */
package org.moskito.central.connectors.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.net.URI;
import javax.ws.rs.core.UriBuilder;
import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.configureme.ConfigurationManager;
import org.moskito.central.Snapshot;
import org.moskito.central.connectors.AbstractCentralConnector;
import org.moskito.central.connectors.rest.RESTConnectorConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RESTConnector
extends AbstractCentralConnector {
    private static final Logger log = LoggerFactory.getLogger(RESTConnector.class);
    private RESTConnectorConfig connectorConfig;
    private volatile Client client;

    public void setConfigurationName(String configurationName) {
        this.connectorConfig = new RESTConnectorConfig();
        ConfigurationManager.INSTANCE.configureAs((Object)this.connectorConfig, configurationName);
        log.debug("Config: " + this.connectorConfig);
        this.client = this.getClient();
    }

    protected void sendData(Snapshot snapshot) {
        WebResource resource = this.client.resource(this.getBaseURI());
        ((WebResource.Builder)resource.accept(new String[]{"application/json"}).type("application/json")).post((Object)snapshot);
    }

    private Client getClient() {
        Client client = Client.create((ClientConfig)this.getClientConfig());
        if (this.connectorConfig.isBasicAuthEnabled()) {
            client.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.connectorConfig.getLogin(), this.connectorConfig.getPassword()));
        }
        return client;
    }

    protected ClientConfig getClientConfig() {
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getClasses().add(JacksonJaxbJsonProvider.class);
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        return clientConfig;
    }

    protected URI getBaseURI() {
        return UriBuilder.fromUri((String)("http://" + this.connectorConfig.getHost() + this.connectorConfig.getResourcePath())).port(this.connectorConfig.getPort()).build(new Object[0]);
    }

    protected RESTConnectorConfig getConnectorConfig() {
        return this.connectorConfig;
    }
}

