/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.vector;

import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.OneMin;
import org.monospark.geometrix.vector.Vec;

public final class VecLengthHelper {
    private static final double SMALLEST_POSITIVE_POWER_2_DOUBLE = Math.sqrt(Double.longBitsToDouble(1L));
    private static final double BIGGEST_POSITIVE_POWER_2_DOUBLE = Math.sqrt(Double.longBitsToDouble(Double.doubleToLongBits(Double.POSITIVE_INFINITY) - 1L));
    private static final double SMALLEST_NEGATIVE_POWER_2_DOUBLE = -SMALLEST_POSITIVE_POWER_2_DOUBLE;
    private static final double BIGGEST_NEGATIVE_POWER_2_DOUBLE = -BIGGEST_POSITIVE_POWER_2_DOUBLE;
    private static final double NORMALIZE_LIMIT = 1.0E-310;

    private VecLengthHelper() {
    }

    private static VecLengthState getVecLengthState(double[] values) {
        int i;
        for (i = 0; i < values.length; ++i) {
            if (!(values[i] > BIGGEST_POSITIVE_POWER_2_DOUBLE) && !(values[i] < BIGGEST_NEGATIVE_POWER_2_DOUBLE)) continue;
            return VecLengthState.TOO_LONG;
        }
        for (i = 0; i < values.length; ++i) {
            if (!(values[i] > SMALLEST_POSITIVE_POWER_2_DOUBLE) && !(values[i] < SMALLEST_NEGATIVE_POWER_2_DOUBLE)) continue;
            return VecLengthState.NORMAL;
        }
        return VecLengthState.TOO_SHORT;
    }

    static double calculateLength(double[] values) {
        VecLengthState state = VecLengthHelper.getVecLengthState(values);
        double powLength = 0.0;
        for (int i = 0; i < values.length; ++i) {
            double value = values[i] * state.getMultiplier();
            double pow = value * value;
            powLength += pow;
        }
        return Math.sqrt(powLength) * (1.0 / state.getMultiplier());
    }

    static <D extends OneMin> Vec<D> normalize(Vec<D> v) {
        double sum = VecLengthHelper.calculateElementSum(v);
        if (sum < 1.0E-310) {
            double[] sumShares = new double[((Dimension)v.getDimension()).getCount()];
            for (int i = 0; i < ((Dimension)v.getDimension()).getCount(); ++i) {
                sumShares[i] = v.getElement(i) / sum;
            }
            return VecLengthHelper.normalize(Vec.create(v.getDimension(), sumShares));
        }
        double length = VecLengthHelper.calculateLength(v.getValues());
        double[] newValues = new double[((Dimension)v.getDimension()).getCount()];
        for (int i = 0; i < ((Dimension)v.getDimension()).getCount(); ++i) {
            newValues[i] = v.getElement(i) / length;
        }
        return Vec.create(v.getDimension(), newValues);
    }

    private static double calculateElementSum(Vec<?> v) {
        double sum = 0.0;
        for (int i = 0; i < ((Dimension)v.getDimension()).getCount(); ++i) {
            sum += Math.abs(v.getElement(i));
        }
        return sum;
    }

    static boolean isInRadius(double radius, double[] values) {
        double add = 0.0;
        for (int i = 0; i < values.length; ++i) {
            add += values[i];
        }
        if (add <= radius && add >= -radius) {
            return true;
        }
        return VecLengthHelper.calculateLength(values) <= radius;
    }

    static /* synthetic */ double access$000() {
        return SMALLEST_POSITIVE_POWER_2_DOUBLE;
    }

    static /* synthetic */ double access$100() {
        return BIGGEST_POSITIVE_POWER_2_DOUBLE;
    }

    private static enum VecLengthState {
        TOO_SHORT(VecLengthHelper.access$000() / Double.MIN_VALUE),
        NORMAL(1.0),
        TOO_LONG(VecLengthHelper.access$100() / Double.MAX_VALUE);

        private double multiplier;

        private VecLengthState(double multiplier) {
            this.multiplier = multiplier;
        }

        private double getMultiplier() {
            return this.multiplier;
        }
    }
}

