/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.vector;

import java.util.Objects;
import java.util.Optional;
import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.OneMin;
import org.monospark.geometrix.dimensions.Three;
import org.monospark.geometrix.matrix.Mat;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecLengthHelper;

public final class VecHelper {
    private VecHelper() {
    }

    public static <D extends OneMin> Vec<D> add(Vec<D> v1, Vec<D> v2) {
        Optional<Vec<D>> add = VecHelper.addOptional(v1, v2);
        return add.orElseThrow(() -> new IllegalArgumentException("Resulting vector lies outside of the vector space"));
    }

    public static <D extends OneMin> Optional<Vec<D>> addOptional(Vec<D> v1, Vec<D> v2) {
        Objects.requireNonNull(v1, "First vector can't be null");
        Objects.requireNonNull(v2, "Second vector can't be null");
        double[] newValues = new double[((Dimension)v1.getDimension()).getCount()];
        for (int i = 0; i < ((Dimension)v1.getDimension()).getCount(); ++i) {
            double newValue = v1.getElement(i) + v2.getElement(i);
            if (Double.isInfinite(newValue)) {
                return Optional.empty();
            }
            newValues[i] = newValue;
        }
        return Vec.createOptional(newValues);
    }

    public static <D extends OneMin> Vec<D> subtract(Vec<D> v1, Vec<D> v2) {
        Optional<Vec<D>> subtract = VecHelper.subtractOptional(v1, v2);
        return subtract.orElseThrow(() -> new IllegalArgumentException("Resulting vector lies outside of the vector space"));
    }

    public static <D extends OneMin> Optional<Vec<D>> subtractOptional(Vec<D> v1, Vec<D> v2) {
        Objects.requireNonNull(v1, "First vector can't be null");
        Objects.requireNonNull(v2, "Second vector can't be null");
        double[] newValues = new double[((Dimension)v1.getDimension()).getCount()];
        for (int i = 0; i < ((Dimension)v1.getDimension()).getCount(); ++i) {
            double newValue = v1.getElement(i) - v2.getElement(i);
            if (Double.isInfinite(newValue)) {
                return Optional.empty();
            }
            newValues[i] = newValue;
        }
        return Vec.createOptional(newValues);
    }

    public static <D extends OneMin> Vec<D> multiply(Vec<D> v, double s) {
        Optional<Vec<D>> multiply = VecHelper.multiplyOptional(v, s);
        return multiply.orElseThrow(() -> new IllegalArgumentException("Resulting vector lies outside of the vector space"));
    }

    public static <D extends OneMin> Optional<Vec<D>> multiplyOptional(Vec<D> v, double s) {
        Objects.requireNonNull(v, "Vector can't be null");
        if (Double.isInfinite(s) || Double.isNaN(s)) {
            throw new IllegalArgumentException("Invalid scalar for multiplication: " + s);
        }
        double[] newValues = new double[((Dimension)v.getDimension()).getCount()];
        for (int i = 0; i < ((Dimension)v.getDimension()).getCount(); ++i) {
            double mult = v.getElement(i) * s;
            if (Double.isInfinite(mult)) {
                return Optional.empty();
            }
            newValues[i] = mult;
        }
        return Vec.createOptional(newValues);
    }

    public static <R extends OneMin, C extends OneMin> Vec<C> multiply(Vec<R> v, Mat<R, C> m) {
        Optional<Vec<C>> multiply = VecHelper.multiplyOptional(v, m);
        return multiply.orElseThrow(() -> new IllegalArgumentException("Resulting vector lies outside of the vector space"));
    }

    public static <R extends OneMin, C extends OneMin> Optional<Vec<C>> multiplyOptional(Vec<R> v, Mat<R, C> m) {
        Objects.requireNonNull(m, "Matrix can't be null");
        Objects.requireNonNull(v, "Vector can't be null");
        double[] newVecValues = new double[((Dimension)m.getColumnDimension()).getCount()];
        for (int column = 0; column < ((Dimension)m.getColumnDimension()).getCount(); ++column) {
            double columnValue = 0.0;
            for (int row = 0; row < ((Dimension)m.getRowDimension()).getCount(); ++row) {
                double vecValue = v.getElement(row);
                double matValue = m.getElement(row, column);
                columnValue += vecValue * matValue;
            }
            if (Double.isInfinite(columnValue)) {
                return Optional.empty();
            }
            newVecValues[column] = columnValue;
        }
        return Vec.createOptional(newVecValues);
    }

    public static <D extends OneMin> Vec<D> divide(Vec<D> v, double s) {
        Optional<Vec<D>> divide = VecHelper.divideOptional(v, s);
        return divide.orElseThrow(() -> new IllegalArgumentException("Resulting vector lies outside of the vector space"));
    }

    public static <D extends OneMin> Optional<Vec<D>> divideOptional(Vec<D> v, double s) {
        Objects.requireNonNull(v, "Vector can't be null");
        if (Double.isInfinite(s) || Double.isNaN(s)) {
            throw new IllegalArgumentException("Invalid scalar for division: " + s);
        }
        double[] newValues = new double[((Dimension)v.getDimension()).getCount()];
        for (int i = 0; i < ((Dimension)v.getDimension()).getCount(); ++i) {
            double div = v.getElement(i) / s;
            if (Double.isInfinite(div)) {
                return Optional.empty();
            }
            newValues[i] = div;
        }
        return Vec.createOptional(newValues);
    }

    public static Vec<Three> cross(Vec<Three> v1, Vec<Three> v2) {
        Optional<Vec<Three>> cross = VecHelper.crossOptional(v1, v2);
        return cross.orElseThrow(() -> new IllegalArgumentException("Resulting vector lies outside of the vector space"));
    }

    public static Optional<Vec<Three>> crossOptional(Vec<Three> v1, Vec<Three> v2) {
        Objects.requireNonNull(v1, "First vector can't be null");
        Objects.requireNonNull(v2, "Second vector can't be null");
        double x = v1.getElement(1) * v2.getElement(2) - v1.getElement(2) * v2.getElement(1);
        if (Double.isInfinite(x)) {
            return Optional.empty();
        }
        double y = v1.getElement(2) * v2.getElement(0) - v1.getElement(0) * v2.getElement(2);
        if (Double.isInfinite(y)) {
            return Optional.empty();
        }
        double z = v1.getElement(0) * v2.getElement(1) - v1.getElement(1) * v2.getElement(0);
        if (Double.isInfinite(z)) {
            return Optional.empty();
        }
        return Vec.createOptional(Dimension.THREE, x, y, z);
    }

    public static <D extends OneMin> double dot(Vec<D> v1, Vec<D> v2) {
        Optional<Double> dot = VecHelper.dotOptional(v1, v2);
        return dot.orElseThrow(() -> new IllegalArgumentException("Resulting vector lies outside of the vector space"));
    }

    public static <D extends OneMin> Optional<Double> dotOptional(Vec<D> v1, Vec<D> v2) {
        Objects.requireNonNull(v1, "First vector can't be null");
        Objects.requireNonNull(v2, "Second vector can't be null");
        double dot = 0.0;
        for (int i = 0; i < ((Dimension)v1.getDimension()).getCount(); ++i) {
            dot += v1.getElement(i) * v2.getElement(i);
        }
        return Double.isInfinite(dot) ? Optional.empty() : Optional.of(dot);
    }

    public static <D extends OneMin> Vec<D> negate(Vec<D> v) {
        Objects.requireNonNull(v, "Vector can't be null");
        double[] newValues = new double[((Dimension)v.getDimension()).getCount()];
        for (int i = 0; i < ((Dimension)v.getDimension()).getCount(); ++i) {
            newValues[i] = -v.getElement(i);
        }
        return Vec.create(v.getDimension(), newValues);
    }

    public static double calculateLength(Vec<?> v) {
        Objects.requireNonNull(v, "Vector can't be null");
        return VecLengthHelper.calculateLength(v.getValues());
    }

    public static <D extends OneMin> double calculateAngleBetween(Vec<D> v1, Vec<D> v2) {
        Vec<D> v2Norm;
        Objects.requireNonNull(v1, "First vector can't be null");
        Objects.requireNonNull(v2, "Second vector can't be null");
        if (Vec.isZeroVec(v1)) {
            throw new IllegalArgumentException("First vector must not be a zero vector");
        }
        if (Vec.isZeroVec(v2)) {
            throw new IllegalArgumentException("Second vector must not be a zero vector");
        }
        Vec<D> v1Norm = VecHelper.normalize(v1);
        double dot = VecHelper.dot(v1Norm, v2Norm = VecHelper.normalize(v2));
        if (dot >= 1.0) {
            return 0.0;
        }
        if (dot <= -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(dot));
    }

    public static <D extends OneMin> Vec<D> normalize(Vec<D> v) {
        Objects.requireNonNull(v, "Vector can't be null");
        if (Vec.isZeroVec(v)) {
            throw new IllegalArgumentException("A zero vector can't be normalized");
        }
        return VecLengthHelper.normalize(v);
    }

    public static <D extends OneMin> Vec<D> calculateVectorComponent(Vec<D> v, Vec<D> direc) {
        Objects.requireNonNull(v, "Vector can't be null");
        Objects.requireNonNull(direc, "Direction can't be null");
        if (Vec.isZeroVec(direc)) {
            throw new IllegalArgumentException("Direction vector can't be a zero vector");
        }
        Vec<D> norm = VecHelper.normalize(direc);
        double dot = VecHelper.dot(norm, v);
        return VecHelper.multiplyOptional(norm, dot).get();
    }
}

