/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.vector;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.monospark.geometrix.GeometrixObject;
import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.Four;
import org.monospark.geometrix.dimensions.One;
import org.monospark.geometrix.dimensions.OneMin;
import org.monospark.geometrix.dimensions.Three;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.util.RoundingHelper;
import org.monospark.geometrix.vector.VecLengthHelper;

public final class Vec<D extends OneMin>
extends GeometrixObject {
    private final double[] values;
    private final D dim;

    static <D extends OneMin> Optional<Vec<D>> createOptional(double ... values) {
        return Vec.createOptional((OneMin)Dimension.getDimension(values.length), values);
    }

    public static <D extends OneMin> Vec<D> zero(D dim) {
        double[] zeroValues = new double[dim.getCount()];
        return Vec.create(dim, zeroValues);
    }

    public static Vec<One> one(double x) {
        return Vec.create(Dimension.ONE, x);
    }

    public static Vec<Two> two(double x, double y) {
        return Vec.create(Dimension.TWO, x, y);
    }

    public static Vec<Three> three(double x, double y, double z) {
        return Vec.create(Dimension.THREE, x, y, z);
    }

    public static Vec<Four> four(double x, double y, double z, double w) {
        return Vec.create(Dimension.FOUR, x, y, z, w);
    }

    public static <D extends OneMin> Vec<D> create(D dim, double ... values) {
        return Vec.createOptional(dim, values).orElseThrow(() -> new IllegalArgumentException("Vector lies outside of the vector space"));
    }

    public static <D extends OneMin> Optional<Vec<D>> createOptional(D dim, double ... values) {
        Objects.requireNonNull(dim, "Dimension must be not null");
        if (dim.getCount() != values.length) {
            throw new IllegalArgumentException("Incompatible count and dimension");
        }
        for (int i = 0; i < values.length; ++i) {
            if (!Double.isInfinite(values[i]) && !Double.isNaN(values[i])) continue;
            throw new IllegalArgumentException("The vector element at [" + i + "] is invalid");
        }
        if (!VecLengthHelper.isInRadius(Double.MAX_VALUE, values)) {
            return Optional.empty();
        }
        return Optional.of(new Vec<D>(dim, values));
    }

    public static boolean isZeroVec(Vec<?> v) {
        Objects.requireNonNull(v, "Vector must be not null");
        for (int i = 0; i < ((Dimension)v.getDimension()).getCount(); ++i) {
            if (v.getElement(i) == 0.0) continue;
            return false;
        }
        return true;
    }

    public static boolean isInObjectSpace(Vec<?> v) {
        Objects.requireNonNull(v, "Vector must be not null");
        return VecLengthHelper.isInRadius(8.988465674311579E307, v.getValues());
    }

    private Vec(D dim, double[] values) {
        this.dim = dim;
        this.values = values;
    }

    public double getElement(int index) {
        if (index >= this.values.length || index < 0) {
            throw new IndexOutOfBoundsException("Index is out of bounds. Allowed: 0-" + (this.values.length - 1) + ", but was " + index);
        }
        return this.values[index];
    }

    @Override
    public boolean resembles(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Vec) {
            Vec vec = (Vec)o;
            if (!this.dim.equals(vec.dim)) {
                return false;
            }
            for (int i = 0; i < ((Dimension)this.dim).getCount(); ++i) {
                if (RoundingHelper.areValuesAlmostEqual(this.getElement(i), vec.getElement(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Vec) {
            Vec vec = (Vec)o;
            return Arrays.equals(this.values, vec.values);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.values);
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append('(');
        for (int i = 0; i < ((Dimension)this.dim).getCount(); ++i) {
            b.append(this.getElement(i));
            b.append(',');
        }
        b.deleteCharAt(b.length() - 1);
        b.append(')');
        return b.toString();
    }

    public D getDimension() {
        return this.dim;
    }

    double[] getValues() {
        return this.values;
    }
}

