/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.util;

public final class RoundingHelper {
    public static final double ABSOLUTE_MARGIN_VALUE = Math.pow(10.0, -10.0);
    public static final double RELATIVE_MARGIN_VALUE = Math.pow(10.0, -5.0);

    private RoundingHelper() {
    }

    public static boolean areValuesAlmostEqual(double d1, double d2) {
        if (Double.isInfinite(d1) || Double.isNaN(d1)) {
            throw new IllegalArgumentException("Illegal value for d1: " + d1);
        }
        if (Double.isInfinite(d2) || Double.isNaN(d2)) {
            throw new IllegalArgumentException("Illegal value for d2: " + d2);
        }
        if (d1 == d2) {
            return true;
        }
        double diff = Math.abs(d2 - d1);
        if (diff <= ABSOLUTE_MARGIN_VALUE) {
            return true;
        }
        double max = Math.max(Math.abs(d1), Math.abs(d2));
        return diff <= max * RELATIVE_MARGIN_VALUE;
    }
}

