/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.util;

import java.util.List;
import java.util.function.BiPredicate;

public final class ListHelper {
    private ListHelper() {
    }

    public static <T1, T2> boolean areListContentOrdersEqual(List<T1> list1, List<T2> list2, BiPredicate<T1, T2> equal) {
        if (list1.size() != list2.size()) {
            return false;
        }
        if (ListHelper.areOrdersEqual(list1, list2, equal, false)) {
            return true;
        }
        return ListHelper.areOrdersEqual(list1, list2, equal, true);
    }

    private static <T1, T2> boolean areOrdersEqual(List<T1> list1, List<T2> list2, BiPredicate<T1, T2> equal, boolean reversedOrder) {
        T1 firstItemOf1 = list1.get(0);
        int firstItem2Index = -1;
        for (int i = 0; i < list2.size(); ++i) {
            T2 otherItem = list2.get(i);
            if (!equal.test(firstItemOf1, otherItem)) continue;
            firstItem2Index = i;
            break;
        }
        if (firstItem2Index == -1) {
            return false;
        }
        int list2Displacement = firstItem2Index;
        for (int i = 0; i < list1.size(); ++i) {
            T2 item2;
            T1 item1 = ListHelper.getItemAtLoopedIndex(list1, i);
            if (equal.test(item1, item2 = ListHelper.getItemAtLoopedIndex(list2, list2Displacement + (reversedOrder ? -i : i)))) continue;
            return false;
        }
        return true;
    }

    public static <T> T getItemAtLoopedIndex(List<T> list, int index) {
        int fittingIndex = -1;
        fittingIndex = index < 0 ? list.size() + index % -list.size() : (index >= list.size() ? index % list.size() : index);
        return list.get(fittingIndex);
    }
}

