/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.polygon.model;

import java.util.List;
import java.util.Set;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.lineseg.LineSegHelper;
import org.monospark.geometrix.shape.flat.polygon.PolygonEdge;
import org.monospark.geometrix.shape.flat.polygon.PolygonVertex;
import org.monospark.geometrix.shape.flat.polygon.model.PolygonModel;
import org.monospark.geometrix.shape.flat.polygon.model.PolygonModelFactory;
import org.monospark.geometrix.util.RoundingHelper;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public abstract class PolygonModelType {
    public static final Simple SIMPLE = new Simple();
    public static final Convex CONVEX = new Convex();
    public static final Concave CONCAVE = new Concave();
    private final String name;

    private PolygonModelType(String name) {
        this.name = name;
    }

    abstract boolean canCreate(List<PolygonVertex<Two>> var1, List<PolygonEdge<Two>> var2);

    abstract boolean isPointOnModel(PolygonModel<?> var1, Vec<Two> var2);

    public String toString() {
        return this.name;
    }

    public static final class Concave
    extends Simple {
        private Concave() {
            super("concave");
        }

        @Override
        boolean canCreate(List<PolygonVertex<Two>> vertices, List<PolygonEdge<Two>> edges) {
            if (!super.canCreate(vertices, edges)) {
                return false;
            }
            double firstCross = this.getCrossValue(vertices, 0);
            boolean positive = firstCross > 0.0;
            for (int i = 0; i < vertices.size(); ++i) {
                double cross = this.getCrossValue(vertices, i);
                if (!(positive && cross < 0.0) && (positive || !(cross > 0.0))) continue;
                return true;
            }
            return false;
        }

        private double getCrossValue(List<PolygonVertex<Two>> vertices, int i) {
            PolygonVertex<Two> currentPoint = vertices.get(i);
            PolygonVertex<Two> nextPoint = vertices.get((i + 1) % vertices.size());
            PolygonVertex<Two> previousPoint = vertices.get(i == 0 ? vertices.size() - 1 : i - 1);
            Vec<Two> toPrevious = VecHelper.normalize(VecHelper.subtract(currentPoint.getPoint(), previousPoint.getPoint()));
            Vec<Two> toNext = VecHelper.normalize(VecHelper.subtract(currentPoint.getPoint(), nextPoint.getPoint()));
            return toPrevious.getElement(1) * toNext.getElement(0) - toPrevious.getElement(0) * toNext.getElement(1);
        }
    }

    public static final class Convex
    extends Simple {
        private Convex() {
            super("convex");
        }

        @Override
        boolean canCreate(List<PolygonVertex<Two>> vertices, List<PolygonEdge<Two>> edges) {
            if (!super.canCreate(vertices, edges)) {
                return false;
            }
            double firstCross = this.getCrossValue(vertices, 0);
            boolean positive = firstCross > 0.0;
            for (int i = 0; i < vertices.size(); ++i) {
                double cross = this.getCrossValue(vertices, i);
                if (!(positive && cross < 0.0) && (positive || !(cross > 0.0))) continue;
                return false;
            }
            return true;
        }

        private double getCrossValue(List<PolygonVertex<Two>> vertices, int i) {
            PolygonVertex<Two> currentPoint = vertices.get(i);
            PolygonVertex<Two> nextPoint = vertices.get((i + 1) % vertices.size());
            PolygonVertex<Two> previousPoint = vertices.get(i == 0 ? vertices.size() - 1 : i - 1);
            Vec<Two> toPrevious = VecHelper.normalize(VecHelper.subtract(currentPoint.getPoint(), previousPoint.getPoint()));
            Vec<Two> toNext = VecHelper.normalize(VecHelper.subtract(currentPoint.getPoint(), nextPoint.getPoint()));
            return toPrevious.getElement(1) * toNext.getElement(0) - toPrevious.getElement(0) * toNext.getElement(1);
        }

        @Override
        boolean isPointOnModel(PolygonModel<?> model, Vec<Two> point) {
            for (PolygonEdge<Two> edge : model.getExterior().getEdges()) {
                if (!LineSegHelper.isPointOnLineSegment(edge.getLineSegment(), point)) continue;
                return true;
            }
            for (PolygonEdge<Two> edge : model.getExterior().getEdges()) {
                Vec<Two> negNormal = VecHelper.negate(edge.getNormal());
                Vec<Two> toPoint1 = VecHelper.subtract(point, edge.getLineSegment().getP1());
                Vec<Two> normalToPoint = VecHelper.calculateVectorComponent(toPoint1, negNormal);
                if (RoundingHelper.areValuesAlmostEqual(VecHelper.calculateAngleBetween(normalToPoint, negNormal), 0.0)) continue;
                return false;
            }
            return true;
        }
    }

    public static class Simple
    extends PolygonModelType {
        private Simple() {
            super("simple");
        }

        private Simple(String name) {
            super(name);
        }

        @Override
        boolean canCreate(List<PolygonVertex<Two>> vertices, List<PolygonEdge<Two>> edges) {
            return true;
        }

        @Override
        boolean isPointOnModel(PolygonModel<?> model, Vec<Two> point) {
            Set<PolygonModel<Convex>> convexPolys = PolygonModelFactory.triangulate(model);
            for (PolygonModel<Convex> poly : convexPolys) {
                if (!poly.isPointOnModel(point)) continue;
                return true;
            }
            return false;
        }
    }
}

