/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.polygon.model;

import org.monospark.geometrix.dimensions.Dimension;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.vector.Vec;

public abstract class PolygonModelPointOrder {
    public static final PolygonModelPointOrder CLOCKWISE = new PolygonModelPointOrder("clockwise"){

        @Override
        Vec<Two> createNormal(Vec<Two> vec) {
            return Vec.create(Dimension.TWO, -vec.getElement(1), vec.getElement(0));
        }
    };
    public static final PolygonModelPointOrder COUNTER_CLOCKWISE = new PolygonModelPointOrder("counter-clockwise"){

        @Override
        Vec<Two> createNormal(Vec<Two> vec) {
            return Vec.create(Dimension.TWO, vec.getElement(1), -vec.getElement(0));
        }
    };
    private final String name;

    public static PolygonModelPointOrder getPointOrderBySignedArea(double signedArea) {
        return signedArea < 0.0 ? CLOCKWISE : COUNTER_CLOCKWISE;
    }

    private PolygonModelPointOrder(String name) {
        this.name = name;
    }

    abstract Vec<Two> createNormal(Vec<Two> var1);

    public String toString() {
        return this.name;
    }
}

