/*
 * Decompiled with CFR 0.152.
 */
package org.monospark.geometrix.shape.flat.polygon.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.monospark.geometrix.dimensions.Two;
import org.monospark.geometrix.dimensions.TwoMin;
import org.monospark.geometrix.line.Line;
import org.monospark.geometrix.line.LineHelper;
import org.monospark.geometrix.lineseg.LineSeg;
import org.monospark.geometrix.lineseg.LineSegHelper;
import org.monospark.geometrix.shape.flat.polygon.PolygonEdge;
import org.monospark.geometrix.shape.flat.polygon.PolygonExterior;
import org.monospark.geometrix.shape.flat.polygon.PolygonVertex;
import org.monospark.geometrix.shape.flat.polygon.model.PolygonModel;
import org.monospark.geometrix.shape.flat.polygon.model.PolygonModelPointOrder;
import org.monospark.geometrix.shape.flat.polygon.model.PolygonModelType;
import org.monospark.geometrix.util.ListHelper;
import org.monospark.geometrix.util.RoundingHelper;
import org.monospark.geometrix.vector.Vec;
import org.monospark.geometrix.vector.VecHelper;

public final class PolygonModelFactory {
    public static final int NONE = 0;
    public static final int MERGE_EDGES = 1;
    public static final int VERIFIY_TYPE = 2;
    public static final int CHECK_EDGE_INTERSECTIONS = 4;
    public static final int ALL = 7;

    private PolygonModelFactory() {
    }

    public static <T extends PolygonModelType> Optional<PolygonModel<T>> createPolygonModel(T type, LinkedHashSet<Vec<Two>> points, int actions) {
        boolean fitsType;
        ArrayList<Vec<Two>> modelPoints;
        Objects.requireNonNull(type, "Polygon model type can't be null");
        Objects.requireNonNull(points, "Set of points for the polygon model can't be null");
        if (points.size() < 3) {
            return Optional.empty();
        }
        ArrayList<Vec<Two>> arrayList = modelPoints = (actions & 1) != 0 ? PolygonModelFactory.mergeEdges(points) : new ArrayList<Vec<Two>>(points);
        if (modelPoints.size() < 3) {
            return Optional.empty();
        }
        double signedArea = PolygonModelFactory.calculateSignedArea(modelPoints);
        if (Double.isInfinite(signedArea)) {
            return Optional.empty();
        }
        PolygonModelPointOrder pointOrder = PolygonModelPointOrder.getPointOrderBySignedArea(signedArea);
        List<PolygonEdge<Two>> modelEdges = PolygonModelFactory.calculateEdges(modelPoints, pointOrder);
        if ((actions & 4) != 0 && PolygonModelFactory.checkForEdgeIntersections(modelEdges)) {
            return Optional.empty();
        }
        List<PolygonVertex<Two>> modelVertices = PolygonModelFactory.calculateVertices(modelEdges);
        PolygonExterior<Two> exterior = new PolygonExterior<Two>(modelVertices, modelEdges);
        if ((actions & 2) != 0 && !(fitsType = type.canCreate(modelVertices, modelEdges))) {
            return Optional.empty();
        }
        double area = signedArea < 0.0 ? -signedArea : signedArea;
        return Optional.of(new PolygonModel<T>(area, type, exterior, pointOrder));
    }

    private static <D extends TwoMin> List<Vec<Two>> mergeEdges(Collection<Vec<Two>> shapePoints) {
        ArrayList<Vec<Two>> newPoints = new ArrayList<Vec<Two>>(shapePoints);
        for (int i = 0; i < newPoints.size(); ++i) {
            Vec next = (Vec)newPoints.get((i + 1) % newPoints.size());
            Vec point = (Vec)newPoints.get(i);
            Vec prev = (Vec)newPoints.get(i == 0 ? newPoints.size() - 1 : i - 1);
            Line line = Line.create(prev, VecHelper.subtract(point, prev));
            if (!LineHelper.isPointOnLine(line, next)) continue;
            newPoints.remove(point);
            if (newPoints.size() == 2) {
                return newPoints;
            }
            return PolygonModelFactory.mergeEdges(newPoints);
        }
        return newPoints;
    }

    private static double calculateSignedArea(List<Vec<Two>> shapePoints) {
        double area = 0.0;
        for (int i = 0; i < shapePoints.size(); ++i) {
            int j = (i + 1) % shapePoints.size();
            Vec<Two> iV = shapePoints.get(i);
            Vec<Two> jV = shapePoints.get(j);
            area += iV.getElement(0) * jV.getElement(1);
            area -= jV.getElement(0) * iV.getElement(1);
        }
        return area / 2.0;
    }

    private static List<PolygonVertex<Two>> calculateVertices(List<PolygonEdge<Two>> modelEdges) {
        ArrayList<PolygonVertex<Two>> vertices = new ArrayList<PolygonVertex<Two>>();
        for (int i = 0; i < modelEdges.size(); ++i) {
            PolygonEdge<Two> current = modelEdges.get(i);
            PolygonEdge<Two> previous = ListHelper.getItemAtLoopedIndex(modelEdges, i - 1);
            Vec<Two> point = current.getLineSegment().getP1();
            Vec<Two> normal = VecHelper.normalize(VecHelper.add(current.getNormal(), previous.getNormal()));
            vertices.add(new PolygonVertex<Two>(point, normal));
        }
        return vertices;
    }

    private static List<PolygonEdge<Two>> calculateEdges(List<Vec<Two>> modelPoints, PolygonModelPointOrder pointOrder) {
        ArrayList<PolygonEdge<Two>> borders = new ArrayList<PolygonEdge<Two>>();
        for (int i = 0; i < modelPoints.size(); ++i) {
            Vec<Two> p1 = modelPoints.get(i);
            Vec<Two> p2 = modelPoints.get((i + 1) % modelPoints.size());
            Vec<Two> lineVec = VecHelper.subtract(p2, p1);
            Vec<Two> outNormal = VecHelper.normalize(pointOrder.createNormal(lineVec));
            borders.add(new PolygonEdge<Two>(LineSeg.create(p1, p2), outNormal));
        }
        return borders;
    }

    private static boolean checkForEdgeIntersections(List<PolygonEdge<Two>> edges) {
        for (int i = 0; i < edges.size(); ++i) {
            PolygonEdge<Two> currentEdge = edges.get(i);
            PolygonEdge<Two> previousEdge = edges.get((i + 1) % edges.size());
            PolygonEdge<Two> nextEdge = edges.get(i == 0 ? edges.size() - 1 : i - 1);
            for (int j = 0; j < edges.size(); ++j) {
                PolygonEdge<Two> otherEdge = edges.get(j);
                if (otherEdge.equals(previousEdge) || otherEdge.equals(currentEdge) || otherEdge.equals(nextEdge) || !LineSegHelper.calculateIntersectionPoint(currentEdge.getLineSegment(), otherEdge.getLineSegment()).isPresent()) continue;
                return true;
            }
        }
        return false;
    }

    public static Optional<PolygonModel<PolygonModelType.Convex>> createConvexHull(Set<Vec<Two>> points) {
        Objects.requireNonNull(points, "Points can't be null");
        if (points.size() < 3) {
            return Optional.empty();
        }
        PolygonModel<PolygonModelType.Convex> poly = PolygonModelFactory.createBasePolygon(points);
        if (poly == null) {
            return Optional.empty();
        }
        HashSet<Vec<Two>> pointsLeft = new HashSet<Vec<Two>>(points);
        for (Vec<Two> pointLeft : new HashSet<Vec<Two>>(pointsLeft)) {
            if (!poly.isPointOnModel(pointLeft)) continue;
            pointsLeft.remove(pointLeft);
        }
        PolygonModel<PolygonModelType.Convex> current = poly;
        while (pointsLeft.size() > 0) {
            current = PolygonModelFactory.extendPolygon(current, pointsLeft);
            for (Vec<Two> pLeft : new HashSet<Vec<Two>>(pointsLeft)) {
                if (!current.isPointOnModel(pLeft)) continue;
                pointsLeft.remove(pLeft);
            }
        }
        return Optional.of(current);
    }

    private static PolygonModel<PolygonModelType.Convex> extendPolygon(PolygonModel<PolygonModelType.Convex> p, Set<Vec<Two>> points) {
        PolygonModel<PolygonModelType.Convex> current = p;
        for (PolygonEdge<Two> edge : p.getExterior().getEdges()) {
            Vec<Two> maxPoint = PolygonModelFactory.getMaximumDistancePoint(edge, points);
            if (maxPoint == null) continue;
            current = PolygonModelFactory.insertPointAtBorder(p, edge, maxPoint);
            break;
        }
        return current;
    }

    private static PolygonModel<PolygonModelType.Convex> insertPointAtBorder(PolygonModel<PolygonModelType.Convex> p, PolygonEdge<Two> edge, Vec<Two> point) {
        ArrayList<Vec<Two>> polyPoints = new ArrayList<Vec<Two>>();
        for (PolygonVertex<Two> vertex : p.getExterior().getVertices()) {
            polyPoints.add(vertex.getPoint());
        }
        polyPoints.add(polyPoints.indexOf(edge.getLineSegment().getP2()), point);
        return PolygonModelFactory.createPolygonModel(PolygonModelType.CONVEX, new LinkedHashSet<Vec<Two>>(polyPoints), 0).get();
    }

    private static Vec<Two> getMaximumDistancePoint(PolygonEdge<Two> edge, Set<Vec<Two>> points) {
        double maxDistance = 0.0;
        Vec<Two> maxPoint = null;
        for (Vec<Two> point : points) {
            Vec<Two> toPoint;
            Vec<Two> distance;
            double length;
            if (!PolygonModelFactory.isPointInFrontOfEdge(edge, point) || !((length = VecHelper.calculateLength(distance = VecHelper.calculateVectorComponent(toPoint = VecHelper.subtract(point, edge.getLineSegment().getP1()), edge.getNormal()))) > maxDistance)) continue;
            maxDistance = length;
            maxPoint = point;
        }
        return maxPoint;
    }

    private static boolean isPointInFrontOfEdge(PolygonEdge<Two> edge, Vec<Two> point) {
        if (LineSegHelper.isPointOnLineSegment(edge.getLineSegment(), point)) {
            return true;
        }
        Vec<Two> toPoint1 = VecHelper.subtract(point, edge.getLineSegment().getP1());
        Vec<Two> normalToPoint = VecHelper.calculateVectorComponent(toPoint1, edge.getNormal());
        return RoundingHelper.areValuesAlmostEqual(VecHelper.calculateAngleBetween(normalToPoint, edge.getNormal()), 0.0);
    }

    private static PolygonModel<PolygonModelType.Convex> createBasePolygon(Set<Vec<Two>> points) {
        if (points.size() < 3) {
            return null;
        }
        LineSeg<Two> longest = PolygonModelFactory.createLongestLineSegmentBetweenPoints(points);
        if (longest == null) {
            return null;
        }
        Vec<Two> lineSeg = VecHelper.subtract(longest.getP2(), longest.getP1());
        Vec<Two> thirdPoint = null;
        double length = RoundingHelper.ABSOLUTE_MARGIN_VALUE;
        for (Vec<Two> point : points) {
            Vec<Two> toPoint;
            Vec<Two> side;
            double sideLength;
            if (point.equals(longest.getP1()) || point.equals(longest.getP2()) || !((sideLength = VecHelper.calculateLength(side = VecHelper.subtract(toPoint = VecHelper.subtract(point, longest.getP1()), VecHelper.calculateVectorComponent(toPoint, lineSeg)))) > length)) continue;
            length = sideLength;
            thirdPoint = point;
        }
        if (thirdPoint == null) {
            return null;
        }
        LinkedHashSet<Vec<Two>> polyPoints = new LinkedHashSet<Vec<Two>>();
        polyPoints.add(longest.getP1());
        polyPoints.add(longest.getP2());
        polyPoints.add(thirdPoint);
        return PolygonModelFactory.createPolygonModel(PolygonModelType.CONVEX, polyPoints, 0).get();
    }

    private static <D extends TwoMin> LineSeg<Two> createLongestLineSegmentBetweenPoints(Set<Vec<Two>> allPoints) {
        Vec<Two> p1 = null;
        Vec<Two> p2 = null;
        double dis = 0.0;
        for (Vec<Two> point1 : allPoints) {
            for (Vec<Two> point2 : allPoints) {
                double pDis;
                if (point1.equals(point2) || !((pDis = VecHelper.calculateLength(VecHelper.subtract(point2, point1))) > dis)) continue;
                dis = pDis;
                p1 = point1;
                p2 = point2;
            }
        }
        if (p1 == null && p2 == null) {
            return null;
        }
        return LineSeg.create(p1, p2);
    }

    public static Set<PolygonModel<PolygonModelType.Convex>> triangulate(PolygonModel<?> p) {
        Objects.requireNonNull(p, "Polygon model must be not null");
        if (p.getExterior().getVertices().size() == 3) {
            return Collections.singleton(new PolygonModel<PolygonModelType.Convex>(p.getArea(), PolygonModelType.CONVEX, p.getExterior(), p.getPointOrder()));
        }
        HashSet<PolygonModel<PolygonModelType.Convex>> polys = new HashSet<PolygonModel<PolygonModelType.Convex>>();
        ArrayList<PolygonVertex<Two>> polyPoints = new ArrayList<PolygonVertex<Two>>(p.getExterior().getVertices());
        block0: while (polyPoints.size() > 3) {
            PolygonModel<PolygonModelType.Simple> poly = PolygonModelFactory.createModelByType(PolygonModelType.SIMPLE, polyPoints);
            for (int i = 0; i < poly.getExterior().getVertices().size(); ++i) {
                PolygonModel<PolygonModelType.Convex> ear = PolygonModelFactory.createEar(poly.getExterior().getVertices(), i);
                if (ear == null) continue;
                polys.add(ear);
                polyPoints.remove(i);
                continue block0;
            }
        }
        polys.add(PolygonModelFactory.createModelByType(PolygonModelType.CONVEX, polyPoints));
        return polys;
    }

    private static <T extends PolygonModelType> PolygonModel<T> createModelByType(T type, List<PolygonVertex<Two>> points) {
        return PolygonModelFactory.createPolygonModel(type, new LinkedHashSet<Vec<Two>>(points.stream().map(v -> v.getPoint()).collect(Collectors.toCollection(LinkedHashSet::new))), 0).get();
    }

    private static PolygonModel<PolygonModelType.Convex> createEar(List<PolygonVertex<Two>> vertices, int index) {
        double nNext;
        PolygonVertex<Two> current = vertices.get(index);
        PolygonVertex<Two> prev = ListHelper.getItemAtLoopedIndex(vertices, index - 1);
        PolygonVertex<Two> next = ListHelper.getItemAtLoopedIndex(vertices, index + 1);
        Vec<Two> toPrev = VecHelper.subtract(prev.getPoint(), current.getPoint());
        Vec<Two> toNext = VecHelper.subtract(next.getPoint(), current.getPoint());
        double nPrev = VecHelper.calculateAngleBetween(toPrev, current.getNormal());
        double outerAngle = nPrev + (nNext = VecHelper.calculateAngleBetween(toNext, current.getNormal()));
        if (outerAngle > 180.0) {
            LinkedHashSet<Vec<Two>> points = new LinkedHashSet<Vec<Two>>();
            points.add(prev.getPoint());
            points.add(current.getPoint());
            points.add(next.getPoint());
            return PolygonModelFactory.createPolygonModel(PolygonModelType.CONVEX, points, 0).get();
        }
        return null;
    }
}

